package org.lsst.ccs.gconsole.plugins.alert;

import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.lsst.ccs.bus.messages.Alarm;
import org.lsst.ccs.messaging.StatusMessageListener;

/**
 * Listen for alarms on the status bus, and if/when found popup an alarm dialog
 * @author tonyj
 */
class AlarmListener implements StatusMessageListener, Runnable {

    private final Studio studio;
    private JDialog dialog;
    private JLineConsole console;
    private PrintWriter printWriter;

    public AlarmListener(Studio studio) {
        this.studio = studio;
        try {
            console = new JLineConsole("Alarms");
            printWriter = new PrintWriter(console.getConsoleReader().getOutput(),true);
        } catch (IOException x) {
        }
    }
    
    
    @Override
    public void onStatusMessage(org.lsst.ccs.bus.messages.StatusMessage s) {
        // FIXME: What is the right test for alarm?
        if (s instanceof Alarm) {
            ensureDialogVisible();
            printWriter.println(s);
        }
    }

    @Override
    public void run() {
        if (dialog == null) {
            dialog = createDialog();
        }
        if (!dialog.isVisible()) {
            dialog.setVisible(true);
        }      
    }

    private void ensureDialogVisible() {
        SwingUtilities.invokeLater(this);
    }

    private JDialog createDialog() {
        JOptionPane pane = new JOptionPane();
        pane.setMessageType(JOptionPane.ERROR_MESSAGE);
        pane.setOptions(new Object[]{"Clear Alarm"});
        pane.setMessage(new JScrollPane(console.getView()));
        JDialog dlg = pane.createDialog(studio, "Alarm");
        dlg.setResizable(true);
        dlg.setModal(false);
        dlg.setAlwaysOnTop(true);
        return dlg;
    }
}
