package org.lsst.ccs.gconsole.jas3;

import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.ConsolePluginHandler;

/**
 * {@code ConsolePluginHandler} implementation based on {@code org.freehep.application.studio.Plugin}.
 *
 * @author onoprien
 */
public class PluginHandler extends Plugin implements ConsolePluginHandler {

// -- Fields : -----------------------------------------------------------------
    
    private final ConsolePlugin plugin;
    private final Jas3Console gConsole;

// -- Life cycle : -------------------------------------------------------------
    
    public PluginHandler(ConsolePlugin plugin) {
        gConsole = (Jas3Console) ((Studio)(Application.getApplication())).getLookup().lookup(Console.class);
        this.plugin = plugin;
    }
    
    @Override
    protected void init() throws Throwable {
        plugin.init();
    }

    @Override
    protected void postInit() {
        plugin.postInit();
    }

    @Override
    protected void applicationVisible() {
        plugin.applicationVisible();
    }

    @Override
    protected void shutdown() {
        plugin.shutdown();
    }


// -- Getters : ----------------------------------------------------------------
    
    @Override
    public Console getConsole() {
      return gConsole;
    }

}
