package org.lsst.ccs.gconsole.jas3;

import org.freehep.application.studio.Plugin;
import org.lsst.ccs.Agent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Superclass for LSST CCS plugins.
 * The CCS Graphical Console plugin developers may choose to extend this class instead 
 * of {@code org.freehep.application.studio.Plugin} to use services and convenience
 * methods it provides.
 *
 * @author onoprien
 */
public class LsstPlugin extends Plugin {

// -- Fields : -----------------------------------------------------------------

// -- Getters : ----------------------------------------------------------------
    
    /**
     * Returns AgentMessagingLayer provided by the Jas3 graphical console.
     * Note that access to the busses might not be available during the {@code init()}
     * method execution. Any initialization code that requires messaging access
     * should go to postInit() or applicationVisible() methods.
     * 
     * @throws IllegalStateException if the messaging access has not been initialized yet.
     */
    public AgentMessagingLayer getMessagingAccess() {
        return Agent.getEnvironmentMessagingAccess();
    }
    
    /**
     * Returns the logger associated with the Jas3 graphical console.
     */
    public Logger getLogger() {
        return Logger.getLogger("org.lsst.ccs.ui");
    }

}
