package org.lsst.ccs.gconsole.jas3;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.application.studio.Plugin;
import org.lsst.ccs.gconsole.Console;

/**
 * Plugin that adds generic CCS functionality to Jas3-based graphical console.
 *
 * @author onoprien
 */
public class LsstMasterPlugin extends Plugin {

// -- Private parts : ----------------------------------------------------------

    static private final Logger logger = Logger.getLogger(LsstMasterPlugin.class.getName());

// -- Life cycle : -------------------------------------------------------------

    @Override
    protected void shutdown() {
        Console agent = (Console) getApplication().getLookup().lookup(Console.class);
        if (agent != null) {
            try {
                agent.shutdown();
            } catch (Throwable x) {
                logger.log(Level.WARNING, "Error while shutting down agent " + agent.getName(), x);
            }
        }
    }
    
}
