package org.lsst.ccs.gconsole.jas3;

import org.atteo.classindex.ClassIndex;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.gconsole.ConsolePluginHandler;

/**
 * Jas3-based Graphical Console implementation.
 * 
 * @author onoprien
 */
public class Jas3Console extends Console {
    
// -- Getters : ----------------------------------------------------------------
    
    @Override
    public FreeHEPLookup getLookup() {
        return getApplication().getLookup();
    }
    
    @Override
    public Studio getApplication() {
        return (Studio) Application.getApplication();
    }
    
    
// -- Error reporting : --------------------------------------------------------
    
    @Override
    public void error(String message) {
        getApplication().error(message);
    }
    
    @Override
    public void error(String message, Exception x) {
        getApplication().error(message, x);
    }


// -- Testing : ----------------------------------------------------------------
    
    static public void main(String... args) {
        System.out.println("-- Plugins: \n");
        for (Class<? extends ConsolePluginHandler> x : ClassIndex.getSubclasses(ConsolePluginHandler.class)) {
            System.out.println("Class: "+ x.getName());
        }
    }
    
}
