package org.lsst.ccs.gconsole;

import org.atteo.classindex.IndexSubclasses;

/**
 * Base class for implementing {@link Console} plugins.
 *
 * @author onoprien
 */
@IndexSubclasses
abstract public class ConsolePlugin {
    
// -- Fields : -----------------------------------------------------------------
    
    private ConsolePluginHandler handler;


// -- Life cycle : -------------------------------------------------------------
    
    public void setHandler(ConsolePluginHandler handler) {
        this.handler = handler;
    }

    public void init() throws Throwable {}

    public void postInit() {}

    public void applicationVisible() {}
    
    public void start() {}
    
    public void stop() {}

    public void shutdown() {}


// -- Getters : ----------------------------------------------------------------
    
    public Console getConsole() {
        return handler.getConsole();
    }

}
