package org.lsst.ccs.gconsole;

import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;

/**
 * Base class for implementing Graphical Console subsystem.
 * 
 * @author onoprien
 */
abstract public class Console extends Agent {
    
// -- Construction : -----------------------------------------------------------
    
    protected Console() {
        super("CCS-Graphical-Console", AgentInfo.AgentType.CONSOLE);
    }
    
    
// -- Getters : ----------------------------------------------------------------
    
    abstract public FreeHEPLookup getLookup();
    
    abstract public Studio getApplication();
    
    
// -- Error reporting : --------------------------------------------------------
    
    abstract public void error(String message);
    
    abstract public void error(String message, Exception x);
    
}
