/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import java.util.Arrays;
import java.util.IllegalFormatException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jgroups.logging.Log;

public class Log4JLogImpl
implements Log {
    private static final String FQCN = Log4JLogImpl.class.getName();
    private final Logger logger;

    public Log4JLogImpl(String category) {
        this.logger = Logger.getLogger((String)category);
    }

    public Log4JLogImpl(Class<?> category) {
        this.logger = Logger.getLogger(category);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void debug(String msg) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debug(this.format(msg, args));
        }
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, throwable);
    }

    @Override
    public void error(String msg) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, null);
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            this.error(this.format(format, args));
        }
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, throwable);
    }

    @Override
    public void fatal(String msg) {
        this.logger.log(FQCN, (Priority)Level.FATAL, (Object)msg, null);
    }

    @Override
    public void fatal(String msg, Object ... args) {
        if (this.isFatalEnabled()) {
            this.fatal(this.format(msg, args));
        }
    }

    @Override
    public void fatal(String msg, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.FATAL, (Object)msg, throwable);
    }

    @Override
    public void info(String msg) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this.isInfoEnabled()) {
            this.info(this.format(msg, args));
        }
    }

    @Override
    public void trace(Object msg) {
        this.logger.log(FQCN, (Priority)Level.TRACE, msg, null);
    }

    @Override
    public void trace(String msg) {
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)msg, null);
    }

    @Override
    public void trace(String msg, Object ... args) {
        if (this.isTraceEnabled()) {
            this.trace(this.format(msg, args));
        }
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)msg, throwable);
    }

    @Override
    public void warn(String msg) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, null);
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this.isWarnEnabled()) {
            this.warn(this.format(msg, args));
        }
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, throwable);
    }

    @Override
    public String getLevel() {
        Level level = this.logger.getLevel();
        return level != null ? level.toString() : "off";
    }

    @Override
    public void setLevel(String level) {
        Level new_level = Log4JLogImpl.strToLevel(level);
        if (new_level != null) {
            this.logger.setLevel(new_level);
        }
    }

    protected String format(String format, Object ... args) {
        try {
            return String.format(format, args);
        }
        catch (IllegalFormatException ex) {
            this.error("Illegal format string \"" + format + "\", args=" + Arrays.toString(args));
        }
        catch (Throwable t) {
            this.error("Failure formatting string: format string=" + format + ", args=" + Arrays.toString(args));
        }
        return format;
    }

    protected static Level strToLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.toLowerCase().trim()).equals("fatal")) {
            return Level.FATAL;
        }
        if (level.equals("error")) {
            return Level.ERROR;
        }
        if (level.equals("warn")) {
            return Level.WARN;
        }
        if (level.equals("warning")) {
            return Level.WARN;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("debug")) {
            return Level.DEBUG;
        }
        if (level.equals("trace")) {
            return Level.TRACE;
        }
        return null;
    }
}

