/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.utilities;

import org.lsst.ccs.config.NamesAndTag;

public class ConfigUtils {
    public static NamesAndTag namesFromPath(String pathName) {
        String subsystemName = "";
        String configName = "";
        String tag = "";
        String cat = "";
        if (ConfigUtils.isAPath(pathName)) {
            int indexDot = pathName.lastIndexOf(46);
            int lastPath = pathName.lastIndexOf(47);
            String rawName = pathName.substring(lastPath + 1, indexDot);
            String[] elements = rawName.split("_");
            switch (elements.length) {
                case 3: {
                    configName = String.valueOf(elements[2]) + ":";
                    cat = elements[2];
                }
                case 2: {
                    configName = String.valueOf(configName) + elements[1];
                }
                case 1: {
                    tag = elements[0];
                }
            }
        } else {
            configName = pathName;
        }
        return new NamesAndTag(subsystemName, configName, tag, cat);
    }

    public static NamesAndTag namesFromDescriptionPath(String pathName) {
        String subsystemName = "";
        String configName = "";
        String tag = "";
        tag = pathName.substring(pathName.lastIndexOf("/") + 1);
        return new NamesAndTag(subsystemName, configName, tag);
    }

    public static NamesAndTag namesFromPaths(String descriptionPathName, String configurationPathName) {
        NamesAndTag descNT = ConfigUtils.namesFromDescriptionPath(descriptionPathName);
        String subsystemName = descNT.getSubsystemName();
        String configName = descNT.getConfigName();
        String tagName = descNT.getTag();
        String catName = descNT.getCat();
        if (configurationPathName != null) {
            NamesAndTag confNT = ConfigUtils.namesFromPath(configurationPathName);
            if (!confNT.getSubsystemName().isEmpty() && !subsystemName.equals(confNT.getSubsystemName())) {
                throw new IllegalArgumentException(" subsystem names differs :" + subsystemName + " <> " + confNT.getSubsystemName());
            }
            String newConfigName = confNT.getConfigName();
            if (configName.length() != 0 && newConfigName.length() != 0 && !configName.equals(newConfigName)) {
                throw new IllegalArgumentException(" configuration name clash :" + configName + " <> " + newConfigName);
            }
            if (newConfigName.length() != 0) {
                configName = newConfigName;
            }
            String newTagName = confNT.getTag();
            if (tagName.length() != 0 && newTagName.length() != 0 && !descNT.getTag().equals(newTagName)) {
                throw new IllegalArgumentException(" tag name clash :" + tagName + " <> " + newTagName);
            }
            if (newTagName.length() != 0) {
                tagName = newTagName;
            }
            catName = confNT.getCat();
        }
        return new NamesAndTag(subsystemName, configName, tagName, catName);
    }

    public static String baseNameFromNames(String configName, String tagName) {
        return ConfigUtils.baseNameFromNames(configName, tagName, "");
    }

    public static String baseNameFromNames(String configName, String tagName, String catName) {
        String part4 = null;
        if (ConfigUtils.isAPath(configName)) {
            return configName;
        }
        String part1 = tagName;
        String part2 = configName;
        String part3 = catName;
        String baseName = part1;
        if (part2.isEmpty()) {
            if (!part3.isEmpty()) {
                baseName = String.valueOf(baseName) + "__" + part3;
            }
        } else {
            baseName = String.valueOf(baseName) + "_" + part2;
            if (!part3.isEmpty()) {
                baseName = String.valueOf(baseName) + "_" + part3;
            }
        }
        if (part4 != null && !part4.isEmpty()) {
            baseName = String.valueOf(baseName) + "_" + part4;
        }
        return baseName;
    }

    public static boolean isAPath(String string) {
        int lastPath;
        if (string == null) {
            return false;
        }
        int lastDot = string.lastIndexOf(".");
        return lastDot > (lastPath = string.lastIndexOf("/"));
    }
}

