/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.ConfigurationServiceException;

public abstract class ConfigurableSubsystem
extends Subsystem {
    private ConfigurationProxy configurationProxy;
    private Set<String> categories;

    public ConfigurableSubsystem(String name, ConfigurationProxy configProxy) {
        super(name, AgentInfo.AgentType.WORKER);
        this.configurationProxy = configProxy;
        this.categories = configProxy.getCategorySet();
    }

    public String getTag() {
        return this.configurationProxy.getTagName();
    }

    public ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    protected void setConfigurationProxy(ConfigurationProxy configurationProxy) {
        this.configurationProxy = configurationProxy;
    }

    protected TreeNode getInitialDescriptiveNode(String ... taggedCategories) {
        return this.configurationProxy.getInitialDescriptiveNode(this.parseConfigurationStringWithDefaults(taggedCategories));
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public final void saveAllChanges() throws ConfigurationServiceException {
        try {
            this.configurationProxy.saveChangesForCategories(this.categories);
            this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), this.getState()));
        }
        catch (ConfigurationServiceException ex) {
            this.updateInternalState(ex.getMessage(), new AgentState[]{ConfigurationState.UNCONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), this.getState()));
            throw ex;
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategories(String ... categories) throws ConfigurationServiceException {
        try {
            this.configurationProxy.saveChangesForCategories(this.parseCategories(categories));
            ConfigurationInfo configInfo = this.configurationProxy.buildConfigurationInfo();
            if (configInfo.hasChanges()) {
                this.updateInternalState("", new AgentState[]{ConfigurationState.DIRTY});
            } else {
                this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURED});
            }
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(configInfo, null));
        }
        catch (ConfigurationServiceException ex) {
            this.updateInternalState(ex.getMessage(), new AgentState[]{ConfigurationState.UNCONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), null));
            throw ex;
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategoriesAs(String ... taggedCategories) throws ConfigurationServiceException {
        Map<String, String> newTaggedCategories = this.parseConfigurationString(taggedCategories);
        try {
            this.configurationProxy.saveChangesForCategoriesAs(newTaggedCategories);
            ConfigurationInfo configInfo = this.configurationProxy.buildConfigurationInfo();
            if (configInfo.hasChanges()) {
                this.updateInternalState("", new AgentState[]{ConfigurationState.DIRTY});
            } else {
                this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURED});
            }
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(configInfo, this.getState()));
        }
        catch (Exception ex) {
            this.updateInternalState(ex.getMessage(), new AgentState[]{ConfigurationState.UNCONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), this.getState()));
            throw ex;
        }
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION)
    public void dropAllChanges() throws Exception {
        try {
            this.configurationProxy.dropUnsavedChangesForCategories(this.categories);
            this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), null));
        }
        catch (Exception ex) {
            this.updateInternalState(ex.getMessage(), new AgentState[]{ConfigurationState.UNCONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), null));
        }
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void dropChangesForCategories(String ... categories) throws Exception {
        try {
            this.configurationProxy.dropUnsavedChangesForCategories(this.parseCategories(categories));
            ConfigurationInfo configInfo = this.configurationProxy.buildConfigurationInfo();
            if (configInfo.hasChanges()) {
                this.updateInternalState("", new AgentState[]{ConfigurationState.DIRTY});
            } else {
                this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURED});
            }
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(configInfo, null));
        }
        catch (Exception ex) {
            this.updateInternalState(ex.getMessage(), new AgentState[]{ConfigurationState.UNCONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), null));
            throw ex;
        }
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(String ... taggedCategories) throws ConfigurationServiceException, Exception {
        try {
            this.configurationProxy.loadCategories(this.parseConfigurationStringWithDefaults(taggedCategories));
            this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), null));
        }
        catch (Exception ex) {
            this.updateInternalState("", new AgentState[]{ConfigurationState.UNCONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), null));
            throw ex;
        }
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void loadCategories(String ... taggedCategories) throws ConfigurationServiceException, Exception {
        if (taggedCategories.length == 0) {
            return;
        }
        try {
            this.configurationProxy.loadCategories(this.parseConfigurationString(taggedCategories));
            ConfigurationInfo configInfo = this.configurationProxy.buildConfigurationInfo();
            if (configInfo.hasChanges()) {
                this.updateInternalState("", new AgentState[]{ConfigurationState.DIRTY});
            } else {
                this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURED});
            }
        }
        catch (Exception ex) {
            this.updateInternalState(ex.getMessage(), new AgentState[]{ConfigurationState.UNCONFIGURED});
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), this.getState()));
            throw ex;
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.CONFIGURATION)
    public ConfigurationInfo getConfigurationInfo() {
        return this.configurationProxy.buildConfigurationInfo();
    }

    public abstract ComponentLookupService getLookup();

    private Map<String, String> parseConfigurationString(String ... taggedCategories) {
        return ConfigurableSubsystem.parseConfigurationString(this.categories, taggedCategories);
    }

    public void change(String componentName, String parameterName, Object value) throws Exception {
        this.configurationProxy.change((Configurable)this.getLookup().getComponentByName(componentName), parameterName, value);
        this.updateInternalState("", new AgentState[]{ConfigurationState.DIRTY});
        this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(), this.getState()));
    }

    @Override
    public void doStart() {
        ConfigurationInfo configInfo = this.configurationProxy.buildConfigurationInfo();
        this.updateInternalState("", new AgentState[]{configInfo.getConfigurationState()});
        this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(configInfo, this.getState()));
    }

    public static Map<String, String> rawParseConfigurationString(String ... configNames) {
        return ConfigurableSubsystem.parseConfigurationString(null, configNames);
    }

    public static Map<String, String> parseConfigurationString(Set<String> categorySet, String ... configNames) {
        HashMap<String, String> res = new HashMap<String, String>();
        String[] stringArray = configNames;
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.isEmpty()) {
                res.put("", "");
            } else if (!s.contains(":")) {
                res.put("", s);
            } else {
                String[] keyVal = s.split(":", -1);
                if (keyVal.length != 2) {
                    throw new IllegalArgumentException("configuration " + keyVal.length);
                }
                if (categorySet != null && !categorySet.contains(keyVal[0])) {
                    throw new IllegalArgumentException("unexisting category " + keyVal[0]);
                }
                res.put(keyVal[0], keyVal[1]);
            }
            ++n2;
        }
        return res;
    }

    private Map<String, String> parseConfigurationStringWithDefaults(String ... taggedCategories) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String cat : this.categories) {
            res.put(cat, "");
        }
        res.putAll(this.parseConfigurationString(taggedCategories));
        return res;
    }

    private Set<String> parseCategories(String ... categories) {
        HashSet<String> res = new HashSet<String>();
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            if (!this.categories.contains(cat)) {
                throw new IllegalArgumentException("unexisting category " + cat);
            }
            res.add(cat);
            ++n2;
        }
        return res;
    }
}

