/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurableSubsystem;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeLookup;
import org.lsst.ccs.utilities.functions.MutableReference;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.EffectiveNode;

public class NodeModularSubsystem
extends ConfigurableSubsystem {
    private ComponentLookupService lookup;
    private Configurable mainObject;
    private ConfigurationInfo configurationInfo;
    private DescriptiveNode modifiedDescriptiveNode;
    private EffectiveNode effectiveNode;
    private ArrayList<ViewValue> preOrderComponentList = new ArrayList();
    private List<ViewValue> preOrderUnmodifiableView = Collections.unmodifiableList(this.preOrderComponentList);

    public NodeModularSubsystem(String subsystemName, String tagName, ConfigurationProxy configurationProxy, String ... taggedCategories) throws Exception {
        super(subsystemName, configurationProxy);
        this.modifiedDescriptiveNode = (DescriptiveNode)this.getInitialDescriptiveNode(taggedCategories);
        this.effectiveNode = BootUtils.getEffectiveNode(this.modifiedDescriptiveNode);
        this.lookup = new NodeLookup(this, this.effectiveNode);
        this.getConfigurationProxy().setLookup(this.lookup);
        this.realRegisterNodes(this.effectiveNode);
        this.mainObject = (Configurable)this.effectiveNode.getRealValue();
        this.doInitComponents();
    }

    protected void updateHeartBeat(StatusHeartBeat s) {
    }

    public ComponentLookupService getLookup() {
        return this.lookup;
    }

    public List<ViewValue> getPreOrderComponentList() {
        return this.preOrderUnmodifiableView;
    }

    private void realRegisterNodes(EffectiveNode node) {
        String key = node.getKey();
        Object value = node.getRealValue();
        this.preOrderComponentList.add(new ViewValue(key, value));
        ArrayList children = node.getChildren();
        if (children != null) {
            for (EffectiveNode child : children) {
                this.realRegisterNodes(child);
            }
        }
        if (value instanceof Configurable) {
            Configurable configurable = (Configurable)value;
            configurable.setEnvironment(new Configurable.Environment(key, configurable, this.getConfigurationProxy(), this.lookup));
        }
    }

    private void doInitComponents() {
        this.mainObject.proceduralWalk(Configurable::init, null);
    }

    public void doStart() {
        super.doStart();
        this.mainObject.proceduralWalk(Configurable::start, null);
    }

    public void postStart() throws HardwareException {
        this.callPostStart(this.mainObject);
    }

    private void callPostStart(Configurable goal) throws HardwareException {
        goal.postStart();
        for (Configurable configurable : goal.listChildren()) {
            this.callPostStart(configurable);
        }
    }

    public void doShutdown() {
        log.fine((Object)("Subsystem " + this.getName() + " shutdown starting"));
        this.mainObject.proceduralWalk(Configurable::shutdownNow, null);
    }

    protected Configurable getCommandDestination(String commandDestination) {
        Configurable configurable = null;
        String configurableName = "main";
        if (commandDestination.contains("/")) {
            configurableName = commandDestination.substring(commandDestination.indexOf("/") + 1);
        }
        if ((configurable = (Configurable)this.lookup.getComponentByName(configurableName)) == null) {
            throw new IllegalArgumentException(" no such configurable " + configurableName + " for command destination");
        }
        return configurable;
    }

    @Command(description="halt", type=Command.CommandType.SIGNAL)
    public void abort() {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="halt with expected max delay", type=Command.CommandType.SIGNAL)
    public void abort(long expectedMaxDelay) {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT, expectedMaxDelay));
    }

    @Command(description="stops with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        super.stop(expectedMaxDelay);
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.STOP, expectedMaxDelay));
    }

    @Command(description="stops hardware", type=Command.CommandType.ACTION)
    public void stop() throws HardwareException {
        this.stop(Long.MAX_VALUE);
    }

    @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
    public void stopAndWait(long expectedMaxDelay) throws HardwareException, InterruptedException {
        this.stop(expectedMaxDelay);
        int step = 10;
        long fracDelay = expectedMaxDelay / (long)step;
        HardwareException lastExc = null;
        int i = 0;
        while (i < step) {
            try {
                Thread.sleep(fracDelay);
                this.checkAllHardwareStopped();
                return;
            }
            catch (HardwareException e) {
                lastExc = e;
                ++i;
            }
        }
        throw lastExc;
    }

    public void checkHardware() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        MutableReference excList = new MutableReference();
        mainModule.treeWalk(configurable -> {
            block3: {
                if (configurable instanceof HardwareController) {
                    try {
                        return ((HardwareController)configurable).checkHardware();
                    }
                    catch (HardwareException e) {
                        mutableReference.reference = new HardwareException(String.valueOf(configurable.toString()) + " fails check", (Throwable)e, (HardwareException)((Object)((Object)mutableReference.reference)));
                        if (!e.isFatal()) break block3;
                        return TreeWalkerDiag.STOP;
                    }
                }
            }
            return TreeWalkerDiag.GO;
        }, null);
        if (excList.reference != null) {
            throw (HardwareException)((Object)excList.reference);
        }
    }

    public void checkAllHardwareStarted() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        MutableReference excList = new MutableReference();
        mainModule.proceduralWalk(configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStarted();
                }
                catch (HardwareException e) {
                    mutableReference.reference = new HardwareException(String.valueOf(configurable.toString()) + "not started ", (Throwable)e, (HardwareException)((Object)((Object)mutableReference.reference)));
                }
            }
        }, null);
        if (excList.reference != null) {
            throw (HardwareException)((Object)excList.reference);
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        MutableReference excList = new MutableReference();
        mainModule.proceduralWalk(configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStopped();
                }
                catch (HardwareException e) {
                    mutableReference.reference = new HardwareException(String.valueOf(configurable.toString()) + "not stopped ", (Throwable)e, (HardwareException)((Object)((Object)mutableReference.reference)));
                }
            }
        }, null);
        if (excList.reference != null) {
            throw (HardwareException)((Object)excList.reference);
        }
    }
}

