/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.ParameterFilter;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ConfigurableSubsystem;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.gruth.jutils.DescriptiveNode;

public class LocalMergeToBinary {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: java org.lsst.ccs.startup.LocalMergeToBinary pathName propertiesFile [-boot]\n where filename is  xx.ser or xx.groovy or xx.groo\n where propertiesFile is  xx_configName_.properties\n pathName could be file (with '/' file separator) or resource path\n option -boot then boots a subsystem with all data");
            System.exit(1);
        }
        String pathName = args[0];
        String propertiesFile = args[1];
        NamesAndTag namesAndTag = ConfigUtils.namesFromPaths((String)pathName, (String)propertiesFile);
        DescriptiveNode componentNode = BootUtils.getDescriptiveNode(pathName);
        if (componentNode == null) {
            throw new IllegalArgumentException(" not supported : " + pathName);
        }
        SubsystemDescription description = Factories.createSubsystemDescription((String)namesAndTag.getSubsystemName(), (String)namesAndTag.getTag(), (String)"", (String)"", (Serializable)componentNode, (DataFlavour)DataFlavour.PURE_OBJECT_TREE, (ParameterFilter)SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
        LocalConfigurationProxy localProxy = new LocalConfigurationProxy(description);
        DescriptiveNode res = (DescriptiveNode)localProxy.getInitialDescriptiveNode(ConfigurableSubsystem.parseConfigurationString((Set)description.getCategorySet(), (String[])new String[]{propertiesFile}));
        String newPathName = String.valueOf(namesAndTag.toString()) + ".ser";
        FileOutputStream os = new FileOutputStream(newPathName);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(res);
        oos.flush();
        oos.close();
    }
}

