/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.PresetList;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.PresetsDialog;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowPanel;

public final class TimeWindowComboBox
extends JComboBox {
    private static final String CUSTOM_BUTTON = "Choose...";
    private static final String PRESETS_BUTTON = "Presets...";
    private static final String DEFAULT_NAME = "custom";
    private static final int MAX_PRESETS = 10;
    private final PresetList timeWindowList;
    private volatile TimeWindow selection;

    public TimeWindowComboBox(Studio application) {
        this.timeWindowList = new PresetList(application);
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setMaximumRowCount(15);
        Model model = new Model(this.timeWindowList);
        this.setModel(model);
        this.setSelectedIndex(1);
        this.selection = model.getSelectedItem();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindow ts = TimeWindowComboBox.this.myModel().getSelectedItem();
                switch (ts.getName()) {
                    case "Choose...": {
                        ts = TimeWindowPanel.editTimeWindow(TimeWindowComboBox.this, null);
                        if (ts == null) {
                            TimeWindowComboBox.this.setSelectedItem(TimeWindowComboBox.this.selection);
                            break;
                        }
                        if (ts.getName().isEmpty()) {
                            ts.setName(TimeWindowComboBox.DEFAULT_NAME);
                            if (TimeWindowComboBox.DEFAULT_NAME.equals(TimeWindowComboBox.this.selection.getName())) {
                                TimeWindowComboBox.this.myModel().removeElementAt(4);
                            }
                            TimeWindowComboBox.this.myModel().insertElementAt(ts, 4);
                            TimeWindowComboBox.this.setSelectedIndex(4);
                        } else {
                            TimeWindowComboBox.this.timeWindowList.insert(ts);
                            Model model = new Model(TimeWindowComboBox.this.timeWindowList);
                            model.setSelectedItem(ts);
                            TimeWindowComboBox.this.setModel(model);
                        }
                        TimeWindowComboBox.this.selection = ts;
                        break;
                    }
                    case "Presets...": {
                        ts = PresetsDialog.managePresets(TimeWindowComboBox.this, TimeWindowComboBox.this.timeWindowList);
                        if (ts == null) {
                            ts = TimeWindowComboBox.this.selection;
                        }
                        ts.touch();
                        Model model = new Model(TimeWindowComboBox.this.timeWindowList);
                        int index = model.getIndexOf(ts);
                        if (index == -1) {
                            index = 1;
                        }
                        TimeWindowComboBox.this.selection = (TimeWindow)model.getElementAt(index);
                        model.setSelectedItem(TimeWindowComboBox.this.selection);
                        TimeWindowComboBox.this.setModel(model);
                        break;
                    }
                    default: {
                        if (!TimeWindowComboBox.DEFAULT_NAME.equals(ts.getName())) {
                            ts.touch();
                            if (TimeWindowComboBox.DEFAULT_NAME.equals(TimeWindowComboBox.this.selection.getName())) {
                                TimeWindowComboBox.this.myModel().removeElementAt(4);
                            }
                        }
                        TimeWindowComboBox.this.selection = ts;
                    }
                }
            }
        });
    }

    private Model myModel() {
        return (Model)super.getModel();
    }

    public TimeWindow getSelectedTimeWindow() {
        return this.selection;
    }

    public PresetList getPresetList() {
        return this.timeWindowList;
    }

    private class Model
    extends DefaultComboBoxModel<TimeWindow> {
        Model(PresetList tsList) {
            this.addElement(new TimeWindow(TimeWindowComboBox.CUSTOM_BUTTON));
            TimeWindow selectedItem = new TimeWindow("Last Hour", "now-3600", "now", false);
            this.addElement(selectedItem);
            this.addElement(new TimeWindow("Last 6 Hours", "now-21600", "now", false));
            this.addElement(new TimeWindow("Last 24 Hours", "now-86400", "now", false));
            List<TimeWindow> customRanges = tsList.getRecent(10);
            for (TimeWindow ts : customRanges) {
                this.addElement(ts);
            }
            this.addElement(new TimeWindow(TimeWindowComboBox.PRESETS_BUTTON));
            this.setSelectedItem(selectedItem);
        }

        @Override
        public TimeWindow getSelectedItem() {
            return (TimeWindow)super.getSelectedItem();
        }
    }

    private class Renderer
    implements ListCellRenderer {
        private final ListCellRenderer horse;
        private final JPanel separatorPanel = new JPanel(new BorderLayout());
        private final JSeparator separator = new JSeparator();

        Renderer(ListCellRenderer renderer) {
            this.horse = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.horse.getListCellRendererComponent(list, ((TimeWindow)value).getName(), index, isSelected, cellHasFocus);
            if (index == 0 || index == 3) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "South");
                comp = this.separatorPanel;
            } else if (index > 4 && index == TimeWindowComboBox.this.getItemCount() - 1) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "North");
                comp = this.separatorPanel;
            }
            return comp;
        }
    }
}

