/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Plot;
import org.lsst.ccs.gconsole.plugins.trending.PlotMaker;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.utilities.logging.Logger;

public final class AutoRefresh {
    private static final Logger logger = Logger.getLogger((String)AutoRefresh.class.getName());
    private final LsstTrendingPlugin plugin;
    private ScheduledFuture periodicRefresh;
    private ScheduledThreadPoolExecutor executor;
    private final int DATA_FETCHER_MAX_THREADS = 2;
    private PageListener pageListener;
    private volatile long[] delayBounds;
    private volatile boolean cancel;

    public AutoRefresh(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
    }

    public void setDelay(long min, long max, TimeUnit unit) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        this.delayBounds = min == max ? new long[]{TimeUnit.MILLISECONDS.convert(min, unit)} : new long[]{TimeUnit.MILLISECONDS.convert(min, unit), TimeUnit.MILLISECONDS.convert(max, unit)};
    }

    public synchronized void start() {
        TrendingPreferences pref = this.plugin.getPreferences();
        this.setDelay(pref.refreshMin(), pref.refreshMax(), TimeUnit.SECONDS);
        if (this.executor == null) {
            ThreadFactory tFactory = new ThreadFactory(){
                ThreadFactory horse = Executors.defaultThreadFactory();
                int id = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = this.horse.newThread(r);
                    thread.setPriority(Math.min(5, Thread.currentThread().getPriority() - 1));
                    thread.setName("Autorefresh executor " + this.id++);
                    return thread;
                }
            };
            this.executor = new ScheduledThreadPoolExecutor(2, tFactory);
        } else if (this.periodicRefresh != null) {
            this.periodicRefresh.cancel(true);
        }
        this.schedulePeriodicTask();
        this.pageListener = pe -> {
            if (pe.getID() == 3999) {
                try {
                    PlotPage page = (PlotPage)pe.getPageContext().getPage();
                    this.executor.execute(() -> {
                        try {
                            this.refreshPage(page);
                        }
                        catch (Throwable throwable) {}
                    });
                }
                catch (ClassCastException | NullPointerException runtimeException) {}
            }
        };
        this.plugin.getApplication().getPageManager().addPageListener(this.pageListener);
    }

    public synchronized void stop() {
        this.cancel = true;
        this.plugin.getApplication().getPageManager().removePageListener(this.pageListener);
        this.pageListener = null;
        this.executor.shutdown();
        this.executor = null;
    }

    public synchronized void updatePreferences() {
        TrendingPreferences pref = this.plugin.getPreferences();
        long minDelay = this.delayBounds[0];
        this.setDelay(pref.refreshMin(), pref.refreshMax(), TimeUnit.SECONDS);
        if (minDelay != this.delayBounds[0] && this.periodicRefresh != null) {
            this.periodicRefresh.cancel(true);
            this.schedulePeriodicTask();
        }
    }

    private void refreshAll() {
        PageManager pm = this.plugin.getApplication().getPageManager();
        for (Object o : new ArrayList(pm.pages())) {
            try {
                PlotPage page = (PlotPage)((PageContext)o).getPage();
                this.refreshPage(page);
            }
            catch (ClassCastException | NullPointerException runtimeException) {}
        }
    }

    private void refreshVisible() {
        PageManager pm = this.plugin.getApplication().getPageManager();
        for (Object o : new ArrayList(pm.pages())) {
            try {
                PlotPage page = (PlotPage)((PageContext)o).getPage();
                if (!((Component)page).isShowing()) continue;
                this.refreshPage(page);
            }
            catch (ClassCastException | NullPointerException runtimeException) {}
        }
    }

    private void refreshPage(PlotPage page) {
        int n = page.numberOfRegions();
        int i = 0;
        while (i < n) {
            Plotter plotter;
            if (this.cancel || Thread.currentThread().isInterrupted()) {
                return;
            }
            PlotRegion region = page.region(i);
            if (this.isRefreshRequired(region) && (plotter = region.currentPlot()) != null) {
                boolean needUpdate = false;
                long time = System.currentTimeMillis();
                for (Object plottedObject : PlotMaker.getPlotterData(plotter)) {
                    try {
                        Plot plot = (Plot)plottedObject;
                        needUpdate = plot.getChannel().refresh(plot, time) || needUpdate;
                    }
                    catch (ClassCastException classCastException) {}
                }
                if (needUpdate) {
                    SwingUtilities.invokeLater(() -> this.plugin.getPlotMaker().refresh(region, null, new PlotMaker.Options[0]));
                }
            }
            ++i;
        }
    }

    private long computeDelay(Plot pd) {
        if (this.delayBounds.length == 1) {
            return this.delayBounds[0];
        }
        long delay = Math.round(pd.getGranularity() * 1.1);
        return Math.min(this.delayBounds[1], Math.max(delay, this.delayBounds[0]));
    }

    private boolean isRefreshRequired(PlotRegion region) {
        Plotter plotter = region.currentPlot();
        if (plotter == null) {
            return false;
        }
        return PlotMaker.getPlotterData(plotter).stream().anyMatch(plottedObject -> {
            try {
                Plot pd = (Plot)plottedObject;
                if (!pd.getTimeWindow().isFixed()) {
                    return pd.getTimeStamp() + this.computeDelay(pd) < System.currentTimeMillis();
                }
            }
            catch (ClassCastException classCastException) {}
            return false;
        });
    }

    private void schedulePeriodicTask() {
        Runnable periodicTask = () -> {
            try {
                this.refreshVisible();
            }
            catch (Throwable throwable) {}
        };
        this.cancel = false;
        this.periodicRefresh = this.executor.scheduleWithFixedDelay(periodicTask, this.delayBounds[0], this.delayBounds[0], TimeUnit.MILLISECONDS);
    }
}

