/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.jms;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.lsst.ccs.gconsole.plugins.jms.JmsPreferences;

class JmsPreferencesPanel
extends JPanel {
    private final JmsPreferences prefs;
    private JPanel jPanel1;
    private JCheckBox jmsTransportCheckbox;
    private JSpinner portSpinner;
    private JTextField serverTextField;

    JmsPreferencesPanel(JmsPreferences prefs) {
        this.prefs = prefs;
        this.initComponents();
        this.setEnabled();
    }

    void apply() {
        boolean transportChanged = this.jmsTransportCheckbox.isSelected() ^ this.prefs.isUseTransport();
        int newPort = ((Number)this.portSpinner.getValue()).intValue();
        boolean serverOrPortChanged = newPort != this.prefs.getJmsPort() || !this.serverTextField.getText().equals(this.prefs.getJmsServer());
        this.prefs.setJmsPort(newPort);
        this.prefs.setJmsServer(this.serverTextField.getText());
        this.prefs.setUseTransport(this.jmsTransportCheckbox.isSelected());
        if (transportChanged || serverOrPortChanged) {
            JOptionPane.showMessageDialog(this, "Console must be restarted for transport change to take effect.");
        }
    }

    private void setEnabled() {
        boolean enabled = this.jmsTransportCheckbox.isSelected();
        this.jPanel1.setEnabled(enabled);
        Component[] componentArray = this.jPanel1.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setEnabled(enabled);
            ++n2;
        }
    }

    private void initComponents() {
        this.jmsTransportCheckbox = new JCheckBox();
        this.jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.serverTextField = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.portSpinner = new JSpinner();
        this.jmsTransportCheckbox.setSelected(this.prefs.isUseTransport());
        this.jmsTransportCheckbox.setText("Use JMS transport (rather than default)");
        this.jmsTransportCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsPreferencesPanel.this.jmsTransportCheckboxActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("JMS properties"));
        jLabel1.setText("Server:");
        this.serverTextField.setText(this.prefs.getJmsServer());
        jLabel2.setText("Port:");
        this.portSpinner.setModel(new SpinnerNumberModel(this.prefs.getJmsPort(), 1, 65535, 1));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel2).addComponent(jLabel1)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverTextField).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.portSpinner, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.serverTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.portSpinner, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jmsTransportCheckbox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jmsTransportCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jmsTransportCheckboxActionPerformed(ActionEvent evt) {
        if (!this.prefs.canUseTransport()) {
            JOptionPane.showMessageDialog(this, "Transport not available.");
            this.jmsTransportCheckbox.setSelected(false);
        }
        this.setEnabled();
    }
}

