/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Font;
import java.io.IOException;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.lsst.ccs.utilities.logging.Logger;

public class HTMLTextPane
extends JTextPane {
    private static final int MAX_LENGTH = 10000;
    HTMLEditorKit kit;
    HTMLDocument doc;
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.plugin.jas3.dictionary");

    public HTMLTextPane() {
        this.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.doc = new HTMLDocument();
        this.setEditorKit(this.kit);
        Font font = new Font("Monospaced", 0, 15);
        String bodyrule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt;}";
        this.doc.getStyleSheet().addRule(bodyrule);
        this.setDocument(this.doc);
    }

    public void insertHTML(String s) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), s, 0, 0, null);
            int overLength = this.doc.getLength() - 10000;
            if (overLength > 0) {
                this.removeOverLength(overLength);
            }
        }
        catch (BadLocationException ex) {
            this.log.error((Object)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
        }
    }

    private void removeOverLength(int overLength) throws BadLocationException {
        this.doc.remove(0, overLength);
    }
}

