/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.plugin.jas3.dictionary.AgentDefaultTableModel;
import org.lsst.ccs.plugin.jas3.dictionary.AgentTable;
import org.lsst.ccs.plugin.jas3.dictionary.ArgInputPanel;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListPanel;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListener;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryTreePanel;
import org.lsst.ccs.plugin.jas3.dictionary.HTMLTextPane;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryTreeMainPanel
extends JPanel
implements ListSelectionListener,
AgentPresenceListener,
ActionListener {
    private CommandListener commandListener;
    private final Logger logger = Logger.getLogger((String)"org.lsst.ccs.plugin.jas3.dictionary");
    private CommandListPanel cmdList;
    private AgentTable agentTable;
    private DictionaryTreePanel dictionaryTree;
    private ArgInputPanel argInputPanel;
    private HTMLTextPane resultPane;
    private JButton sendCmdButton;
    private JButton refreshAgentsButton;
    private JPanel topPane;
    private final JCheckBox[] checkBoxArray = new JCheckBox[AgentInfo.AgentType.values().length];
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";

    DictionaryTreeMainPanel(CommandListener cmdListener) {
        super(new BorderLayout());
        this.commandListener = cmdListener;
        this.agentTable = new AgentTable();
        this.agentTable.getSelectionModel().addListSelectionListener(this);
        this.dictionaryTree = new DictionaryTreePanel(this.commandListener);
        JScrollPane agentsView = new JScrollPane(this.agentTable);
        this.agentTable.setFillsViewportHeight(true);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.dictionaryTree.putClientProperty("JTree.lineStyle", lineStyle);
        }
        JScrollPane treeView = new JScrollPane(this.dictionaryTree);
        this.cmdList = new CommandListPanel();
        this.dictionaryTree.addTreeSelectionListener(this.cmdList);
        this.cmdList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DictionaryCommand cmd;
                if (e.getClickCount() == 2 && (cmd = (DictionaryCommand)DictionaryTreeMainPanel.this.cmdList.getSelectedValue()).getArguments().length == 0) {
                    DictionaryTreeMainPanel.this.sendCommand();
                }
            }
        });
        JScrollPane cmdListView = new JScrollPane(this.cmdList);
        this.topPane = new JPanel(new GridLayout(1, 3));
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.setPreferredSize(new Dimension(300, 800));
        URL url = this.getClass().getResource("/org/lsst/ccs/plugin/jas3/dictionary/refresh_24dp.png");
        this.refreshAgentsButton = new JButton();
        this.refreshAgentsButton.setIcon(new ImageIcon(url));
        this.refreshAgentsButton.setToolTipText("Refresh");
        this.refreshAgentsButton.addActionListener(this);
        JPanel checkBoxPanel = new JPanel(new GridLayout(4, 2));
        AgentInfo.AgentType[] agentTypeArray = AgentInfo.AgentType.values();
        int n = agentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AgentInfo.AgentType type = agentTypeArray[n2];
            this.checkBoxArray[type.id()] = new JCheckBox(type.displayName());
            this.checkBoxArray[type.id()].addItemListener(this.agentTable);
            this.checkBoxArray[type.id()].setName(type.toString());
            checkBoxPanel.add(this.checkBoxArray[type.id()]);
            ++n2;
        }
        JPanel leftPanelBottom = new JPanel(new BorderLayout());
        leftPanelBottom.add((Component)checkBoxPanel, "Center");
        leftPanelBottom.add((Component)this.refreshAgentsButton, "South");
        leftPane.add((Component)agentsView, "Center");
        leftPane.add((Component)leftPanelBottom, "South");
        this.add((Component)leftPane, "West");
        this.topPane.add(treeView);
        this.topPane.add(cmdListView);
        this.argInputPanel = new ArgInputPanel();
        this.cmdList.addListSelectionListener(this.argInputPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.sendCmdButton = new JButton(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/plugin/jas3/dictionary/ic_send_black_24dp.png")));
        this.sendCmdButton.setText("Send");
        this.sendCmdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionaryTreeMainPanel.this.sendCommand();
            }
        });
        buttonPane.add(this.sendCmdButton);
        this.add((Component)buttonPane, "South");
        JPanel topPaneRightPanel = new JPanel(new BorderLayout());
        topPaneRightPanel.add((Component)this.argInputPanel, "Center");
        topPaneRightPanel.add((Component)buttonPane, "South");
        this.topPane.add(topPaneRightPanel);
        this.resultPane = new HTMLTextPane();
        JScrollPane resultPaneView = new JScrollPane(this.resultPane);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.topPane);
        splitPane.setBottomComponent(resultPaneView);
        splitPane.setContinuousLayout(true);
        this.add((Component)splitPane, "Center");
        this.checkBoxArray[AgentInfo.AgentType.WORKER.id()].setSelected(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.dictionaryTree.setModel(new DefaultTreeModel(null));
        this.argInputPanel.clearForm();
        if (this.agentTable.getSelectedRow() >= 0) {
            String selectedSubsystem = ((AgentInfo)this.agentTable.getValueAt(this.agentTable.getSelectedRow(), 0)).getName();
            new IsEMWorker(selectedSubsystem).execute();
            this.dictionaryTree.updateData(selectedSubsystem);
        }
    }

    public void connecting(final AgentInfo agent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((DefaultTableModel)DictionaryTreeMainPanel.this.agentTable.getModel()).addRow(new Object[]{agent});
            }
        });
    }

    public void disconnecting(AgentInfo agent) {
        ((AgentDefaultTableModel)this.agentTable.getModel()).removeRow(agent);
    }

    public void sendCommand() {
        String rootNode;
        TreeBranch destinationNode = (TreeBranch)this.dictionaryTree.getLastSelectedPathComponent();
        String destination = destinationNode.toString();
        if (!destination.equals(rootNode = this.dictionaryTree.getModel().getRoot().toString())) {
            destination = String.valueOf(rootNode) + "/" + destination;
        }
        String s = "";
        DictionaryCommand cmd = (DictionaryCommand)this.cmdList.getSelectedValue();
        if (cmd != null) {
            int n = cmd.getArguments().length;
            Object[] p = new Object[n];
            int i = 0;
            while (i < n) {
                p[i] = this.parse(this.argInputPanel.getArgInput()[i].getText());
                s = String.valueOf(s) + p[i] + " ";
                ++i;
            }
            new SendCommandWorker(cmd.getCommandName(), p, destination).execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new SwingWorker<Object[][], String>(){

            @Override
            protected Object[][] doInBackground() throws Exception {
                return DictionaryTreeMainPanel.this.commandListener.getConnectedAgents();
            }

            @Override
            public void done() {
                try {
                    ((AgentDefaultTableModel)DictionaryTreeMainPanel.this.agentTable.getModel()).update((Object[][])this.get());
                }
                catch (InterruptedException ex) {
                    DictionaryTreeMainPanel.this.logger.error((Object)ex);
                }
                catch (ExecutionException ex) {
                    DictionaryTreeMainPanel.this.logger.error((Object)ex);
                }
                if (DictionaryTreeMainPanel.this.agentTable.getSelectedRow() >= 0) {
                    String selectedSubsystem = ((AgentInfo)DictionaryTreeMainPanel.this.agentTable.getValueAt(DictionaryTreeMainPanel.this.agentTable.getSelectedRow(), 0)).getName();
                    new IsEMWorker(selectedSubsystem).execute();
                }
            }
        }.execute();
    }

    private Object parse(String s) {
        if (s.startsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.matches("-?[0-9]+")) {
            return Integer.parseInt(s);
        }
        if (s.matches("-?[0-9]*[.][0-9]*|-?[0-9]*[.][0-9]*e-?[0-9]+")) {
            return Double.parseDouble(s);
        }
        return s;
    }

    private class IsEMWorker
    extends SwingWorker<Boolean, String> {
        private String destination;

        IsEMWorker(String destination) {
            this.destination = destination;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            return DictionaryTreeMainPanel.this.commandListener.isInEngineeringMode(this.destination);
        }

        @Override
        public void done() {
            try {
                boolean result = (Boolean)this.get();
                DictionaryTreeMainPanel.this.dictionaryTree.updateRenderer(result);
                DictionaryTreeMainPanel.this.cmdList.updateRenderer(result);
            }
            catch (InterruptedException ex) {
                DictionaryTreeMainPanel.this.logger.error((Object)ex);
            }
            catch (ExecutionException ex) {
                DictionaryTreeMainPanel.this.logger.error((Object)ex);
            }
        }
    }

    public class SendCommandWorker
    extends SwingWorker<String, String> {
        private String cmdName;
        private Object[] cmdArgs;
        private String destination;

        public SendCommandWorker(String cmdName, Object[] cmdArgs, String destination) {
            this.cmdName = cmdName;
            this.cmdArgs = cmdArgs;
            this.destination = destination;
        }

        @Override
        protected String doInBackground() throws Exception {
            DictionaryTreeMainPanel.this.resultPane.insertHTML("invoke " + this.destination + " " + this.cmdName + " ...");
            return DictionaryTreeMainPanel.this.commandListener.sendCommand(this.cmdName, this.cmdArgs, this.destination);
        }

        @Override
        public void done() {
            try {
                String result = (String)this.get();
                if (this.cmdName.equals("switchToEngineeringMode") && result.equals("true") || this.cmdName.equals("switchToNormalMode") && result.equals("ok : VOID")) {
                    boolean isEM = this.cmdName.equals("switchToEngineeringMode");
                    DictionaryTreeMainPanel.this.dictionaryTree.updateRenderer(isEM);
                    DictionaryTreeMainPanel.this.cmdList.updateRenderer(isEM);
                }
                DictionaryTreeMainPanel.this.resultPane.insertHTML(result);
            }
            catch (InterruptedException ex) {
                DictionaryTreeMainPanel.this.logger.error((Object)ex);
            }
            catch (ExecutionException ex) {
                DictionaryTreeMainPanel.this.logger.error((Object)ex);
            }
        }
    }
}

