package org.lsst.ccs.plugin.jas3.trending;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.PlotRegionDropHandler;

/**
 * Drop handler for dropping trending channel nodes into Jas3 plotter regions.
 * 
 * Note that with the current implementation of 
 * <tt>org.freehep.jas.plugin.plotter.DefaultRegion</tt>,
 * <tt>drop(DropTargetDropEvent)</tt> is the only method of this class that ever gets
 * called, and the user action is always <tt>ACTION_LINK</tt>.
 *
 * @author onoprien
 */
public class ChannelDropHandler implements PlotRegionDropHandler {

// -- Private parts : ----------------------------------------------------------
    
    private final LsstTrendingPlugin plugin;
    private PlotRegion region;

// -- Construction and initialization : ----------------------------------------

    public ChannelDropHandler(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
    }

// -- Implementing PlotRegionDropHandler : -------------------------------------
    
    @Override
    public void setPlotRegion(PlotRegion region) {
      this.region = region;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable trans = dtde.getTransferable();
        DataChannelHandler channel = null;
        for (DataFlavor flavor : trans.getTransferDataFlavors()) {
            Class k = flavor.getRepresentationClass();
            if (DataChannelHandler.class.isAssignableFrom(k)) {
                try {
                    channel = (DataChannelHandler) trans.getTransferData(flavor);
                    break;
                } catch (IOException|UnsupportedFlavorException x) {
                }
            }
        }
        if (channel != null) {
            plugin.getPlotMaker().plot(channel, null, false, false, false, plugin.getPreferences().dnd() == 1);
        } else {
            dtde.rejectDrop();
        }
        dtde.dropComplete(true);
    }

}
