package org.lsst.ccs.plugin.jas3.console;

/**
 * Factory that creates {@link MessageFilter} instances.
 * Filters created by the same factory instance are expected to have identical
 * functionality and be able to operate concurrently without interfering with one another.
 *
 * @author onoprien
 */
@FunctionalInterface
public interface MessageFilterFactory {
    
    /** Returns the name of the filters created by this factory. */
    default String getName() {
        return null;
    }
    
    /** Returns the description of the filters created by this factory. */
    default String getDescription() {
        return null;
    }
    
    /** Returns an instance of MessageFilter. */
    MessageFilter get() ;
   
}
