package org.lsst.ccs.plugin.jas3.console;

/**
 * Interface to be implemented by bus message filters that are directly usable by tracers.
 * Applying this filter to a message may modify the message, in addition to accepting or
 * rejecting it.
 * <p>
 * This interface extends MessageFilterFactory and provides a default implementation for
 * its get() method. The method is implemented to return the filter itself. This allows 
 * registering instances of this class with the graphical console lookup to be picked up by
 * the {@link FilterRegistry}. Note that this approach is only safe if the filter's test(...)
 * method can be safely invoked concurrently by multiple threads on multiple messages.
 *
 * @author onoprien
 */
@FunctionalInterface
public interface MessageFilter extends MessageFilterFactory {
    
    /** Returns a reference to this filter. */
    @Override
    default MessageFilter get() {
        return this;
    }
    
    /**
     * Applies this filter to the given message.
     * 
     * @param filteredMessage The message to be filtered.
     * @return The (possibly modified) message if it passes the filter; null otherwise.
     */
    FilteredMessage test(FilteredMessage filteredMessage);
    
}
