package org.lsst.ccs.plugin.jas3.console;

import java.awt.Color;
import java.util.EnumSet;
import org.lsst.ccs.bus.messages.BusMessage;

/**
 *
 * @author onoprien
 */
public interface FilteredMessage {
    
    enum Flag {NONE, START, STOP, PAUSE, RESUME, ATTENTION, ALARM, MARK, LOG}
    
    BusMessage getBusMessage();
    
    BusMessage setBusMessage(BusMessage busMessage);
    
    default String getMessage() {
        return null;
    }
    
    default String setMessage(String message) {
        return null;
    }
    
    default EnumSet<Flag> getFlags() {
        return null;
    }
    
    default void addFlag(Flag action, Flag... actions) {
    }
    
    default void clearFlags() {
    }
    
    default Color getColor() {
        return null;
    }
    
    default Color setColor(Color color) {
        return null;
    }
    
    default Object getProperty(String key) {
        return null;
    }
    
    default Object setProperty(String key, Object value) {
        return null;
    }
    
}
