/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import org.freehep.application.PropertyUtilities;
import org.freehep.jas.services.PreferencesTopic;
import org.lsst.ccs.plugin.jas3.trending.AutoRefresh;
import org.lsst.ccs.plugin.jas3.trending.LsstTrendingPlugin;

public class TrendingPreferences
implements PreferencesTopic {
    private final LsstTrendingPlugin plugin;
    private final String keyPrefix = "org.lsst.trending.";
    private final String useRawDataKey = "rawData";
    private final String nBinsKey = "bins";
    private final String refreshMinKey = "refreshMin";
    private final String refreshMaxKey = "refreshMax";
    private final String drawAlarmKey = "drawAlarm";
    private final String warnOnAlarmKey = "warnOnAlarm";
    private final String drawRmsKey = "drawRms";
    private final String drawMinMaxKey = "drawMinMax";
    private final String doubleClickKey = "doubleClick";
    private final String dndKey = "dnd";
    private final boolean useRawDataDefault = false;
    private final int nBinsDefault = 50;
    private final int refreshMinDefault = 10;
    private final int refreshMaxDefault = 3600;
    private final boolean drawAlarmDefault = false;
    private final boolean warnOnAlarmDefault = false;
    private final boolean drawRmsDefault = false;
    private final boolean drawMinMaxDefault = false;
    private final int doubleClickDefault = -1;
    private final int dndDefault = 0;
    private boolean useRawData;
    private int nBins;
    private int refreshMin;
    private int refreshMax;
    private boolean drawAlarm;
    private boolean warnOnAlarm;
    private boolean drawRms;
    private boolean drawMinMax;
    private int doubleClick;
    private int dnd;

    public TrendingPreferences(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
        this.restore();
    }

    protected final void restore() {
        Properties prop = this.plugin.getApplication().getUserProperties();
        this.useRawData = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.rawData", (boolean)false);
        this.nBins = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.bins", (int)50);
        this.refreshMin = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.refreshMin", (int)10);
        this.refreshMax = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.refreshMax", (int)3600);
        this.drawAlarm = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.drawAlarm", (boolean)false);
        this.warnOnAlarm = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.warnOnAlarm", (boolean)false);
        this.drawRms = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.drawRms", (boolean)false);
        this.drawMinMax = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.drawMinMax", (boolean)false);
        this.doubleClick = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.doubleClick", (int)-1);
        this.dnd = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.dnd", (int)0);
    }

    protected void save() {
        Properties prop = this.plugin.getApplication().getUserProperties();
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.rawData", !this.useRawData ? null : Boolean.valueOf(this.useRawData));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.bins", this.nBins == 50 ? null : Integer.valueOf(this.nBins));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.refreshMin", this.refreshMin == 10 ? null : Integer.valueOf(this.refreshMin));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.refreshMax", this.refreshMax == 3600 ? null : Integer.valueOf(this.refreshMax));
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.drawAlarm", !this.drawAlarm ? null : Boolean.valueOf(this.drawAlarm));
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.warnOnAlarm", !this.warnOnAlarm ? null : Boolean.valueOf(this.warnOnAlarm));
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.drawRms", !this.drawRms ? null : Boolean.valueOf(this.drawRms));
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.drawMinMax", !this.drawMinMax ? null : Boolean.valueOf(this.drawMinMax));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.doubleClick", this.doubleClick == -1 ? null : Integer.valueOf(this.doubleClick));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.dnd", this.dnd == 0 ? null : Integer.valueOf(this.dnd));
    }

    public boolean useRawData() {
        return this.useRawData;
    }

    public int nBins() {
        return this.nBins;
    }

    public int refreshMin() {
        return this.refreshMin;
    }

    public int refreshMax() {
        return this.refreshMax;
    }

    public boolean drawAlarm() {
        return this.drawAlarm;
    }

    public boolean warnOnAlarm() {
        return this.warnOnAlarm;
    }

    public boolean drawRms() {
        return this.drawRms;
    }

    public boolean drawMinMax() {
        return this.drawMinMax;
    }

    public int doubleClick() {
        return this.doubleClick;
    }

    public int dnd() {
        return this.dnd;
    }

    public void setUseRawData(boolean useRawData, boolean save) {
        this.useRawData = useRawData;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.rawData", (Boolean)(!useRawData ? null : Boolean.valueOf(useRawData)));
        }
    }

    public void setNBins(int nBins, boolean save) {
        this.nBins = nBins;
        if (save) {
            PropertyUtilities.setInteger((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.bins", (Integer)(nBins == 50 ? null : Integer.valueOf(nBins)));
        }
    }

    public void setRefresh(int refreshMin, int refreshMax, boolean save) {
        this.refreshMin = refreshMin;
        this.refreshMax = refreshMax;
        AutoRefresh refresher = this.plugin.getAutoRefresh();
        if (refresher != null) {
            refresher.updatePreferences();
        }
        if (save) {
            PropertyUtilities.setInteger((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.refreshMin", (Integer)(refreshMin == 10 ? null : Integer.valueOf(refreshMin)));
            PropertyUtilities.setInteger((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.refreshMax", (Integer)(refreshMax == 3600 ? null : Integer.valueOf(refreshMax)));
        }
    }

    public void setDrawAlarm(boolean drawAlarm, boolean save) {
        this.drawAlarm = drawAlarm;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.drawAlarm", (Boolean)(!drawAlarm ? null : Boolean.valueOf(drawAlarm)));
        }
    }

    public void setWarnOnAlarm(boolean warnOnAlarm, boolean save) {
        this.warnOnAlarm = warnOnAlarm;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.warnOnAlarm", (Boolean)(!warnOnAlarm ? null : Boolean.valueOf(warnOnAlarm)));
        }
    }

    public void setDrawRms(boolean drawRms, boolean save) {
        this.drawRms = drawRms;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.drawRms", (Boolean)(!drawRms ? null : Boolean.valueOf(drawRms)));
        }
    }

    public void setDrawMinMax(boolean drawMinMax, boolean save) {
        this.drawMinMax = drawMinMax;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.drawMinMax", (Boolean)(!drawMinMax ? null : Boolean.valueOf(drawMinMax)));
        }
    }

    public void setDoubleClick(int doubleClick, boolean save) {
        this.doubleClick = doubleClick;
        if (save) {
            PropertyUtilities.setInteger((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.doubleClick", (Integer)(doubleClick == -1 ? null : Integer.valueOf(doubleClick)));
        }
    }

    public void setDnd(int dnd, boolean save) {
        this.dnd = dnd;
        if (save) {
            PropertyUtilities.setInteger((Properties)this.plugin.getApplication().getUserProperties(), (String)"org.lsst.trending.dnd", (Integer)(dnd == 0 ? null : Integer.valueOf(dnd)));
        }
    }

    public String[] path() {
        return new String[]{"LSST", "Trending"};
    }

    public JComponent component() {
        return new GUI();
    }

    public boolean apply(JComponent gui) {
        try {
            boolean out = ((GUI)gui).get();
            if (out) {
                this.save();
            }
            return out;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private class GUI
    extends JPanel {
        private final int HSPACE = 10;
        private final int VSPACE = 5;
        JRadioButton _useRawDataRadio;
        JRadioButton _useStatDataRadio;
        ButtonGroup _dataButtonGroup;
        JCheckBox _nBinsBox;
        JTextField _nBinsField;
        String[] _doubleClickOptions = new String[]{"Show", "Plot", "New Plot", "New Page"};
        JRadioButton[] _doubleClickRadio;
        ButtonGroup _doubleClickGroup;
        String[] _dndOptions = new String[]{"Replace", "Overlay"};
        JRadioButton[] _dndRadio;
        ButtonGroup _dndGroup;
        JCheckBox _drawAlarmBox;
        JCheckBox _warnOnAlarmBox;
        JCheckBox _drawRmsBox;
        JCheckBox _drawMinMaxBox;
        JRadioButton _refreshFixedRadio;
        JRadioButton _refreshAdaptiveRadio;
        ButtonGroup _refreshGroup;
        JTextField _refreshFixedField;
        JTextField _refreshMinField;
        JTextField _refreshMaxField;
        InputVerifier standardVerifier = new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return input.getForeground().equals(Color.BLACK);
            }
        };

        GUI() {
            this.setLayout(new BoxLayout(this, 1));
            Box panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Plotting"));
            panel.setAlignmentX(0.0f);
            Box row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("Double-click action: "));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this._doubleClickRadio = new JRadioButton[this._doubleClickOptions.length];
            this._doubleClickGroup = new ButtonGroup();
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            int i = 0;
            while (i < this._doubleClickOptions.length) {
                this._doubleClickRadio[i] = new JRadioButton(this._doubleClickOptions[i]);
                this._doubleClickGroup.add(this._doubleClickRadio[i]);
                row.add(this._doubleClickRadio[i]);
                ++i;
            }
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("Drag-And-Drop action: "));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this._dndRadio = new JRadioButton[this._dndOptions.length];
            this._dndGroup = new ButtonGroup();
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            i = 0;
            while (i < this._dndOptions.length) {
                this._dndRadio[i] = new JRadioButton(this._dndOptions[i]);
                this._dndGroup.add(this._dndRadio[i]);
                row.add(this._dndRadio[i]);
                ++i;
            }
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._drawAlarmBox = new JCheckBox("Show alarm and warning levels");
            row.add(this._drawAlarmBox);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._warnOnAlarmBox = new JCheckBox("Scan for plots with alarms");
            row.add(this._warnOnAlarmBox);
            row.add(Box.createHorizontalGlue());
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._drawRmsBox = new JCheckBox("Show RMS");
            row.add(this._drawRmsBox);
            row.add(Box.createRigidArea(new Dimension(10, 0)));
            this._drawMinMaxBox = new JCheckBox("Show Min/Max");
            row.add(this._drawMinMaxBox);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Data"));
            panel.setAlignmentX(0.0f);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("Data type: "));
            this._dataButtonGroup = new ButtonGroup();
            this._useRawDataRadio = new JRadioButton("Raw");
            this._dataButtonGroup.add(this._useRawDataRadio);
            row.add(this._useRawDataRadio);
            this._useStatDataRadio = new JRadioButton("Statistical");
            this._dataButtonGroup.add(this._useStatDataRadio);
            row.add(this._useStatDataRadio);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._nBinsBox = new JCheckBox("Reduce to");
            this._nBinsBox.addActionListener(e -> {
                if (this._nBinsBox.isSelected()) {
                    this._nBinsField.setEnabled(true);
                    this._nBinsField.setText(Integer.toString(50));
                } else {
                    this._nBinsField.setEnabled(false);
                    this._nBinsField.setText("");
                }
            });
            row.add(this._nBinsBox);
            this._nBinsField = new JTextField(3);
            this._nBinsField.setMaximumSize(new Dimension(this._nBinsField.getPreferredSize().width, this._nBinsField.getPreferredSize().height));
            this._nBinsField.addCaretListener(e -> {
                String text = this._nBinsField.getText().trim();
                boolean valid = true;
                if (!text.isEmpty()) {
                    try {
                        int value = Integer.parseInt(text);
                        valid = value > 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        valid = false;
                    }
                }
                this._nBinsField.setForeground(valid ? Color.BLACK : Color.RED);
            });
            this._nBinsField.setInputVerifier(this.standardVerifier);
            row.add(this._nBinsField);
            row.add(new JLabel(" bins if possible"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Auto Refresh Interval"));
            panel.setAlignmentX(0.0f);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._refreshGroup = new ButtonGroup();
            this._refreshFixedRadio = new JRadioButton("Fixed: ");
            this._refreshGroup.add(this._refreshFixedRadio);
            this._refreshFixedRadio.addActionListener(e -> {
                if (this._refreshFixedRadio.isSelected()) {
                    this._refreshFixedField.setEnabled(true);
                    this._refreshMinField.setEnabled(false);
                    this._refreshMaxField.setEnabled(false);
                }
            });
            row.add(this._refreshFixedRadio);
            this._refreshFixedField = new JTextField(10);
            this._refreshFixedField.setMaximumSize(new Dimension(this._refreshFixedField.getPreferredSize().width, this._refreshFixedField.getPreferredSize().height));
            this._refreshFixedField.addCaretListener(e -> {
                boolean valid;
                String text = this._refreshFixedField.getText().trim();
                try {
                    int value = Integer.parseInt(text);
                    valid = value > 0;
                }
                catch (NumberFormatException numberFormatException) {
                    valid = false;
                }
                this._refreshFixedField.setForeground(valid ? Color.BLACK : Color.RED);
            });
            this._refreshFixedField.setInputVerifier(this.standardVerifier);
            row.add(this._refreshFixedField);
            row.add(new JLabel(" seconds"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._refreshAdaptiveRadio = new JRadioButton("Adaptive: ");
            this._refreshGroup.add(this._refreshAdaptiveRadio);
            this._refreshAdaptiveRadio.addActionListener(e -> {
                if (this._refreshAdaptiveRadio.isSelected()) {
                    this._refreshFixedField.setEnabled(false);
                    this._refreshMinField.setEnabled(true);
                    this._refreshMaxField.setEnabled(true);
                }
            });
            row.add(this._refreshAdaptiveRadio);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("     Minimum "));
            this._refreshMinField = new JTextField(6);
            this._refreshMinField.setMaximumSize(new Dimension(this._refreshMinField.getPreferredSize().width, this._refreshMinField.getPreferredSize().height));
            row.add(this._refreshMinField);
            row.add(new JLabel(" seconds"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("     Maximum "));
            this._refreshMaxField = new JTextField(6);
            this._refreshMaxField.setMaximumSize(new Dimension(this._refreshMaxField.getPreferredSize().width, this._refreshMaxField.getPreferredSize().height));
            row.add(this._refreshMaxField);
            row.add(new JLabel(" seconds"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            CaretListener minMaxListener = e -> {
                int min = this.getInt(this._refreshMinField);
                if (min < 0) {
                    this._refreshMinField.setForeground(min == -2 ? Color.RED : Color.BLACK);
                    int max = this.getInt(this._refreshMaxField);
                    this._refreshMaxField.setForeground(max == -2 ? Color.RED : Color.BLACK);
                } else {
                    int max = this.getInt(this._refreshMaxField);
                    if (max < 0) {
                        this._refreshMinField.setForeground(Color.BLACK);
                        this._refreshMaxField.setForeground(max == -2 ? Color.RED : Color.BLACK);
                    } else {
                        Color color = min < max ? Color.BLACK : Color.RED;
                        this._refreshMinField.setForeground(color);
                        this._refreshMaxField.setForeground(color);
                    }
                }
            };
            this._refreshMinField.addCaretListener(minMaxListener);
            this._refreshMaxField.addCaretListener(minMaxListener);
            this.add(panel);
            this.add(Box.createVerticalGlue());
            this.set();
        }

        final boolean get() {
            int refreshMax;
            int refreshMin;
            boolean useRawData = this._useRawDataRadio.isSelected();
            int nBins = 0;
            if (this._nBinsBox.isSelected()) {
                try {
                    nBins = Integer.parseInt(this._nBinsField.getText());
                    if (nBins < 1) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            int doubleClick = -1;
            ButtonModel bm = this._doubleClickGroup.getSelection();
            int i = 0;
            while (i < this._doubleClickRadio.length) {
                if (this._doubleClickRadio[i].getModel().equals(bm)) {
                    doubleClick = -1 - i;
                }
                ++i;
            }
            int dnd = 0;
            bm = this._dndGroup.getSelection();
            int i2 = 0;
            while (i2 < this._dndRadio.length) {
                if (this._dndRadio[i2].getModel().equals(bm)) {
                    dnd = i2;
                }
                ++i2;
            }
            boolean drawAlarm = this._drawAlarmBox.isSelected();
            boolean warnOnAlarm = this._warnOnAlarmBox.isSelected();
            boolean drawRms = this._drawRmsBox.isSelected();
            boolean drawMinMax = this._drawMinMaxBox.isSelected();
            if (this._refreshFixedRadio.isSelected()) {
                block17: {
                    try {
                        refreshMin = Integer.parseInt(this._refreshFixedField.getText());
                        if (refreshMin >= 1) break block17;
                        return false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                refreshMax = refreshMin;
            }
            refreshMin = this.getInt(this._refreshMinField);
            if (refreshMin == -2) {
                return false;
            }
            if (refreshMin == -1) {
                refreshMin = 0;
            }
            if ((refreshMax = this.getInt(this._refreshMaxField)) == -2) {
                return false;
            }
            if (refreshMax == -1) {
                refreshMax = Integer.MAX_VALUE;
            }
            if (refreshMin >= refreshMax) {
                return false;
            }
            TrendingPreferences.this.setDoubleClick(doubleClick, false);
            TrendingPreferences.this.setDnd(dnd, false);
            TrendingPreferences.this.setUseRawData(useRawData, false);
            TrendingPreferences.this.setNBins(nBins, false);
            TrendingPreferences.this.setRefresh(refreshMin, refreshMax, false);
            TrendingPreferences.this.setDrawAlarm(drawAlarm, false);
            TrendingPreferences.this.setWarnOnAlarm(warnOnAlarm, false);
            TrendingPreferences.this.setDrawRms(drawRms, false);
            TrendingPreferences.this.setDrawMinMax(drawMinMax, false);
            return true;
        }

        final void set() {
            boolean fixedRefreshRate;
            this._useRawDataRadio.setSelected(TrendingPreferences.this.useRawData);
            this._useStatDataRadio.setSelected(!TrendingPreferences.this.useRawData);
            this._nBinsBox.setSelected(TrendingPreferences.this.nBins > 0);
            if (TrendingPreferences.this.nBins > 0) {
                this._nBinsField.setText(Integer.toString(TrendingPreferences.this.nBins));
            }
            try {
                this._doubleClickRadio[-TrendingPreferences.this.doubleClick - 1].setSelected(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this._doubleClickRadio[0].setSelected(true);
            }
            try {
                this._dndRadio[TrendingPreferences.this.dnd].setSelected(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this._dndRadio[0].setSelected(true);
            }
            this._drawAlarmBox.setSelected(TrendingPreferences.this.drawAlarm);
            this._warnOnAlarmBox.setSelected(TrendingPreferences.this.warnOnAlarm);
            this._drawRmsBox.setSelected(TrendingPreferences.this.drawRms);
            this._drawMinMaxBox.setSelected(TrendingPreferences.this.drawMinMax);
            boolean bl = fixedRefreshRate = TrendingPreferences.this.refreshMin == TrendingPreferences.this.refreshMax;
            if (fixedRefreshRate) {
                this._refreshFixedRadio.setSelected(true);
                this._refreshFixedField.setText(Integer.toString(TrendingPreferences.this.refreshMin));
                this._refreshFixedField.setEnabled(true);
                this._refreshMinField.setEnabled(false);
                this._refreshMaxField.setEnabled(false);
            } else {
                this._refreshAdaptiveRadio.setSelected(true);
                this._refreshMinField.setText(TrendingPreferences.this.refreshMin == 0 ? "" : Integer.toString(TrendingPreferences.this.refreshMin));
                this._refreshMaxField.setText(TrendingPreferences.this.refreshMax == Integer.MAX_VALUE ? "" : Integer.toString(TrendingPreferences.this.refreshMax));
                this._refreshFixedField.setEnabled(false);
                this._refreshMinField.setEnabled(true);
                this._refreshMaxField.setEnabled(true);
            }
        }

        private int getInt(JTextField field) {
            String text = field.getText().trim();
            if (text.isEmpty()) {
                return -1;
            }
            try {
                int out = Integer.parseInt(text);
                return out < 0 ? -2 : out;
            }
            catch (NumberFormatException numberFormatException) {
                return -2;
            }
        }
    }
}

