/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.console;

import org.lsst.ccs.bus.messages.HeartBeatStatus;
import org.lsst.ccs.plugin.jas3.console.FilteredMessage;
import org.lsst.ccs.plugin.jas3.console.MessageFilter;

class HeartBeatSelector
implements MessageFilter {
    private final String name;
    private final String description;
    private final boolean invert;

    HeartBeatSelector(boolean invert) {
        this.invert = invert;
        if (invert) {
            this.name = "Reject Heart Beat";
            this.description = "Rejects heart beat status messages";
        } else {
            this.name = "Heart Beat Selector";
            this.description = "Accepts only heart beat status messages";
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        boolean accept = filteredMessage.getBusMessage() instanceof HeartBeatStatus;
        return this.invert ^ accept ? filteredMessage : null;
    }
}

