package org.lsst.ccs.plugin.jas3.tutorial;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JToolBar;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.xml.sax.SAXException;

/**
 * This is the main entry point of the tutorial plugin.
 * @author tonyj
 */
public class TutorialPlugin extends Plugin {

    private static final Logger logger = Logger.getLogger(TutorialPlugin.class.getName());

    /*
     * The init method of the plugin will be called during JAS startup. This is the place
     * where you should register any functionality that your plugin provides.
     * 
     * Note that the order in which plugins are initialized is unpredictable, so in this method you
     * should not assume that other plugins have or have not been initialized. There
     * is a postInit method which is called after all plugins have been initialized.
     */
    @Override
    protected void init() throws SAXException, IOException {
        logger.info("Initializing tutorial plugin");
        // Get the top level "Studio" application.
        Studio studio = (Studio) Studio.getApplication();
        addMenuItemsAndToolbar(studio);
        registerCommandHandler(studio);
    }

    @Override
    protected void postInit() {
        logger.info("Post init tutorial plugin");
    }

    private void addMenuItemsAndToolbar(Studio studio) throws SAXException, IOException {
        // Get the menu builder corresponding to the studio
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        // Read the definition of the tutorial menus (stored in the maven resources directory)
        URL xml = getClass().getResource("Tutorial.menus");
        // Merge these menus into the application's menus
        builder.build(xml);
        // Find the newly registered toolbar
        JToolBar toolbar = builder.getToolBar("tutorialToolbar");
        // Add it to the toolbar area
        studio.addToolBar(toolbar, toolbar.getName());
    }

    private void registerCommandHandler(Studio studio) {
       studio.getCommandTargetManager().add(new TutorialCommands(studio));
    }
}
