package org.lsst.ccs.plugin.jas3.plots;

import hep.aida.IManagedObject;
import hep.aida.util.XMLUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.messaging.DataStatusListener;
import org.lsst.ccs.bus.messages.AidaPlots;

/**
 * Listen for alarms on the status bus, and if/when found popup an alarm dialog
 *
 * @author tonyj
 */
class PlotsListener implements DataStatusListener {

    private final FreeHEPLookup lookup;
    private final Studio studio;
    private final PlotFactory plotFactory;
    private final FTreeProvider treeProvider;
    private final FTree tree;


    public PlotsListener(Studio studio) {
        this.studio = studio;
        lookup = studio.getLookup();
        plotFactory = (PlotFactory) lookup.lookup(PlotFactory.class);
        treeProvider = (FTreeProvider) lookup.lookup(FTreeProvider.class);
        tree = treeProvider.tree();
    }

    @Override
    public void onDataArrival(String source, long timestamp, String key, Object value) {
        if (value instanceof AidaPlots) {
            if (tree != null) {
                AidaPlots plots = (AidaPlots) value;
                for (String plot : plots.getPlots()) {
                    FTreePath path = new FTreePath(new String[]{source, plot});
                    FTreeNode node = tree.findNode(path);

                    try {

                        IManagedObject obj = XMLUtils.createManagedObject(plots.getPlot(plot));
                        boolean removeNode = node != null;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable() {
                                @Override
                                public void run() {
                                    if (removeNode) {
                                        tree.treeChanged(new FTreeNodeRemovedNotification(studio, path));
                                    }
                                    tree.treeChanged(new FTreeNodeAddedNotification(studio, path, obj));
                                }

                            });

                        } catch (InterruptedException ie) {
                            throw new RuntimeException(ie);
                        } catch (InvocationTargetException ex) {
                            throw new RuntimeException(ex);
                        }
                    } catch (IOException ioe) {
                        throw new RuntimeException("Could not create IManagedObject", ioe);
                    }
                }
            }
        }
    }


}
