package org.lsst.ccs.plugin.jas3.plots;

import java.io.IOException;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.plugin.jas3.LsstPlugin;
import org.xml.sax.SAXException;

/**
 * This plugin deals with creating LSST CCS plots published on the Status bus.
 * @author turri
 */
public class LsstPlotsPlugin extends LsstPlugin {

    private AgentMessagingLayer messagingAccess;

    @Override
    protected void init() throws SAXException, IOException {

        Studio studio = getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(this);

    }

    @Override
    protected void postInit() {
        super.postInit();
        messagingAccess = getMessagingAccess();
    }
    
   
}
