package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * Renderer for switchToEngineering/Normal mode
 * @author emarin
 */
public class EngineeringModeButtonRenderer extends JButton implements TableCellRenderer, ActionListener {

    public EngineeringModeButtonRenderer(){
        setOpaque(true);
    }
    
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        setSelected((boolean)value);
        String s;
        if ((boolean)value){
           s = "/org/lsst/ccs/plugin/jas3/dictionary/ic_settings_red_18dp.png";
        }
        else {
            s = "/org/lsst/ccs/plugin/jas3/dictionary/ic_settings_black_18dp.png";
        }
        setIcon(new ImageIcon(this.getClass().getResource(s)));
        setToolTipText("switch to Engineering/Normal mode");
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
System.out.println("### ACTIONEPERFORMED");    }
    
}