package org.lsst.ccs.plugin.jas3.console;

import java.awt.Color;
import java.util.EnumSet;
import org.lsst.ccs.bus.messages.BusMessage;

/**
 * Default implementation of {@link FilteredMessage}.
 *
 * @author onoprien
 */
public class TracerMessage implements FilteredMessage {

// -- Private parts : ----------------------------------------------------------
    
    private BusMessage busMessage;
    private String message;
    private EnumSet<Flag> actions;
    private Color color;

// -- Construction and initialization : ----------------------------------------
    
    public TracerMessage(BusMessage busMessage) {
        this.busMessage = busMessage;
    }
    
    public TracerMessage(FilteredMessage filteredMessage) {
        busMessage = filteredMessage.getBusMessage();
        message = filteredMessage.getMessage();
        EnumSet<Flag> as = filteredMessage.getFlags();
        actions = (as == null || as.isEmpty()) ? null : EnumSet.copyOf(as);
        color = filteredMessage.getColor();
    }

// -- Implementing FilteredMessage : -------------------------------------------
    
    @Override
    public BusMessage getBusMessage() {
        return busMessage;
    }

    @Override
    public BusMessage setBusMessage(BusMessage busMessage) {
        BusMessage old = this.busMessage;
        this.busMessage = busMessage;
        return old;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public String setMessage(String message) {
        String old = this.message;
        this.message = message;
        return old;
    }

    @Override
    public EnumSet<Flag> getFlags() {
        return actions;
    }
    
    @Override
    public void addFlag(Flag action, Flag... moreActions) {
        if (actions == null) {
            actions = EnumSet.of(action, moreActions);
        } else {
            actions.add(action);
            for (Flag a : moreActions) {
                actions.add(a);
            }
        }
    }
    
    @Override
    public void clearFlags() {
        actions = null;
    }

    @Override
    public Color getColor() {
        return color;
    }

    @Override
    public Color setColor(Color color) {
        Color old = this.color;
        this.color = color;
        return old;
    }

}
