/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.states;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class StateBundle
implements Serializable,
Cloneable {
    private final HashMap<String, Enum> allStates = new LinkedHashMap<String, Enum>();

    public StateBundle(Enum ... states) {
        Enum[] enumArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            this.setState(e);
            ++n2;
        }
    }

    private StateBundle(StateBundle b) {
        this.allStates.putAll(b.allStates);
    }

    public StateBundle mergeState(StateBundle newState) {
        StateBundle clone = this.clone();
        for (Enum e : newState.allStates.values()) {
            clone.setState(e);
        }
        return clone;
    }

    public final <T extends Enum<T>> void setState(T state) {
        this.allStates.put(state.getClass().getSimpleName(), state);
    }

    public final <T extends Enum<T>> Enum getState(Class<T> enumClass) {
        return this.allStates.get(enumClass.getSimpleName());
    }

    public <T extends Enum<T>> boolean isInState(T state) {
        Enum e = this.getState(state.getClass());
        return e == null ? false : e.equals(state);
    }

    public boolean isInState(StateBundle stateBundle) {
        for (Enum e : stateBundle.allStates.values()) {
            if (this.isInState(e)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateBundle)) {
            return false;
        }
        StateBundle state = (StateBundle)o;
        for (String c : this.allStates.keySet()) {
            if (state.isInState(this.allStates.get(c))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Enum e : this.allStates.values()) {
            result = 31 * result + e.hashCode();
        }
        return result;
    }

    public StateBundle clone() {
        StateBundle b = new StateBundle(this);
        return b;
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + " ";
        for (Map.Entry<String, Enum> entry : this.allStates.entrySet()) {
            s = String.valueOf(s) + entry.getKey() + ":" + entry.getValue() + ",";
        }
        return s.substring(0, s.length() - 1);
    }
}

