/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework.test;

import java.util.Observable;
import org.lsst.ccs.framework.Module;

public class ThermalSystem
extends Module {
    private static final long serialVersionUID = 567327460783071688L;
    double heatSinkTemperature = 300.0;
    double heatSinkConductivity = 1.0;
    double heatCapacity = 1.0;
    double inputPower = 0.0;
    double regulPower = 0.0;
    double temperature = 300.0;
    long lastTick;
    long minDelay;
    String tempOutputName;
    String inputPowerName;
    String regulPowerName;

    public ThermalSystem() {
        this.setTickMillis(20);
        this.lastTick = 0L;
        this.minDelay = 2L;
        this.tempOutputName = "temperature";
        this.inputPowerName = "inputPower";
        this.regulPowerName = "regulPower";
    }

    public double getHeatSinkTemperature() {
        return this.heatSinkTemperature;
    }

    public void setHeatSinkTemperature(double heatSinkTemperature) {
        this.heatSinkTemperature = heatSinkTemperature;
    }

    public double getHeatSinkConductivity() {
        return this.heatSinkConductivity;
    }

    public void setHeatSinkConductivity(double heatSinkConductivity) {
        this.heatSinkConductivity = heatSinkConductivity;
    }

    public double getHeatCapacity() {
        return this.heatCapacity;
    }

    public void setHeatCapacity(double heatCapacity) {
        this.heatCapacity = heatCapacity;
    }

    public double getInputPower() {
        return this.inputPower;
    }

    public void setInputPower(double inputPower) {
        this.inputPower = inputPower;
    }

    public double getRegulPower() {
        return this.regulPower;
    }

    public void setRegulPower(double regulPower) {
        this.regulPower = regulPower;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public long getMinDelay() {
        return this.minDelay;
    }

    public void setMinDelay(long minDelay) {
        this.minDelay = minDelay;
    }

    public String getTempOutputName() {
        return this.tempOutputName;
    }

    public void setTempOutputName(String tempOutputName) {
        this.tempOutputName = tempOutputName;
    }

    public String getInputPowerName() {
        return this.inputPowerName;
    }

    public void setInputPowerName(String inputPowerName) {
        this.inputPowerName = inputPowerName;
    }

    public String getRegulPowerName() {
        return this.regulPowerName;
    }

    public void setRegulPowerName(String regulPowerName) {
        this.regulPowerName = regulPowerName;
    }

    @Override
    public void tick() {
        long t = System.currentTimeMillis();
        if (this.lastTick == 0L) {
            this.lastTick = t;
            return;
        }
        if (t - this.lastTick < this.minDelay) {
            return;
        }
        double power = this.inputPower + this.regulPower - (this.temperature - this.heatSinkTemperature) * this.heatSinkConductivity;
        this.temperature += power * (double)(t - this.lastTick) / 1000.0 / this.heatCapacity;
        this.lastTick = t;
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate(this, this.tempOutputName, this.temperature));
    }

    @Override
    public void processUpdate(Observable o, Module.ValueUpdate v) {
        if (v.getName().equals(this.inputPowerName)) {
            this.setInputPower((Double)v.getValue());
        } else if (v.getName().equals(this.regulPowerName)) {
            this.setRegulPower((Double)v.getValue());
        }
    }
}

