/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.mdi.InternalFramePageManager;
import org.freehep.application.mdi.MDIApplication;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.mdi.TabbedPageManager;
import org.freehep.application.studio.EventSender;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.LibInfo;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.PluginMap;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.VersionComparator;
import org.freehep.util.commandline.CommandLine;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Lookup;
import org.xml.sax.EntityResolver;

public class Studio
extends MDIApplication {
    private FreeHEPLookup lookup;
    private EventSender sender = new EventSender();
    private boolean debugExtensions = System.getProperty("debugExtensions") != null;
    private SAXBuilder builder;
    private ArrayList<PluginInfo> loadedPlugins = new ArrayList();
    private ExtensionClassLoader extensionLoader;
    public static final String LOADDIR = "loaddir";
    private boolean isApplicationVisible = false;
    private boolean isApplicationInitialized = false;
    private volatile Throwable atLeastOnePluginFailedToLoad;
    private PluginMap pluginMap;
    private HashMap<String, String[]> pluginBlacklist;
    private String pluginManagerName;

    protected Studio(String name) {
        super(name);
        this.builder = new SAXBuilder(true);
        this.builder.setEntityResolver((EntityResolver)new ClassPathEntityResolver("plugin.dtd", Studio.class));
        this.getLookup().add((Object)new TabbedPageManager(), "Tabbed Panes");
        this.getLookup().add((Object)new InternalFramePageManager(), "Internal Frames");
    }

    private Studio() {
        this("Studio");
    }

    @Override
    protected CommandLine createCommandLine() {
        CommandLine cl = super.createCommandLine();
        cl.addOption("extdir", null, "directory", "Sets the directory to scan for plugins");
        return cl;
    }

    @Override
    protected void init() {
        super.init();
        this.setStatusMessage("Loading extensions...");
        this.loadExtensions();
        this.setStatusMessage("Setting page manager...");
        this.setPageManager(this.createRealPageManager());
        this.reportPluginException();
    }

    private void loadExtensions() {
        PluginInfo pluginManager;
        this.getPluginMap();
        this.extensionLoader = new ExtensionClassLoader(new URL[0]);
        this.createLookup().setClassLoader((ClassLoader)this.extensionLoader);
        Runnable lola = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(Studio.this.extensionLoader);
            }
        };
        lola.run();
        SwingUtilities.invokeLater(lola);
        ArrayList<PluginInfo> cpPlugins = new ArrayList<PluginInfo>();
        for (PluginDir dir : PluginDir.values()) {
            String path = "PLUGIN-inf/" + (dir == PluginDir.BUILTIN ? "" : dir.getLabel() + "/") + "plugins.xml";
            try {
                Enumeration<URL> e = this.extensionLoader.getResources(path);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    List<PluginInfo> plugins = this.buildPluginList(url.openStream());
                    for (PluginInfo p : plugins) {
                        p.setDirectory(dir);
                        cpPlugins.add(p);
                    }
                }
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        this.pluginMap.insertPlugins(cpPlugins);
        if (this.pluginManagerName != null && (pluginManager = this.pluginMap.getActivePlugins().get(this.pluginManagerName)) != null) {
            this.loadPlugins(Collections.singletonList(pluginManager));
        }
        Map<String, PluginInfo> plugins = this.pluginMap.getLoadablePlugins();
        ArrayList<PluginInfo> builtin = new ArrayList<PluginInfo>(plugins.size());
        ArrayList<PluginInfo> others = new ArrayList<PluginInfo>(plugins.size());
        for (PluginInfo plugin : plugins.values()) {
            if (plugin.getDirectory() == PluginDir.BUILTIN) {
                builtin.add(plugin);
                continue;
            }
            others.add(plugin);
        }
        this.loadPlugins(builtin);
        this.loadPlugins(others);
    }

    public static void main(String[] args) {
        try {
            new Studio().createFrame(args).setVisible(true);
        }
        catch (Throwable t) {
            Studio.error(null, "Fatal Error", t);
            System.exit(1);
        }
    }

    protected final void blacklistPlugin(String name, String minVersion, String maxVersion) {
        if (this.pluginBlacklist == null) {
            this.pluginBlacklist = new HashMap();
        }
        this.pluginBlacklist.put(name, new String[]{minVersion, maxVersion});
    }

    protected final void setPluginManagerName(String name) {
        this.pluginManagerName = name;
    }

    public boolean isBlacklisted(PluginInfo plugin) {
        if (this.pluginBlacklist == null) {
            return false;
        }
        String[] versionRange = this.pluginBlacklist.get(plugin.getName());
        if (versionRange == null) {
            return false;
        }
        String version = plugin.getVersion();
        String min = versionRange[0];
        String max = versionRange[1];
        try {
            return !(min != null && VersionComparator.compareVersion((String)version, (String)min) < 0 || max != null && VersionComparator.compareVersion((String)max, (String)version) < 0);
        }
        catch (IllegalArgumentException x) {
            return true;
        }
    }

    public boolean isLoaded(File file) {
        try {
            URL[] classpath;
            URL fileUrl = file.toURI().toURL();
            for (URL url : classpath = this.getExtensionLoader().getURLs()) {
                if (!url.equals(fileUrl)) continue;
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    public EventSender getEventSender() {
        return this.sender;
    }

    public final FreeHEPLookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    @Deprecated
    public String getUserExtensionsDir() {
        return this.getExtensionsDir(PluginDir.USER);
    }

    @Deprecated
    public String getGroupExtensionsDir() {
        return this.getExtensionsDir(PluginDir.GROUP);
    }

    @Deprecated
    public String getSystemExtensionsDir() {
        return this.getExtensionsDir(PluginDir.SYSTEM);
    }

    public String getExtensionsDir(PluginDir dir) {
        String out = null;
        switch (dir) {
            case SYSTEM: {
                out = this.getAppProperties().getProperty("org.freehep.application.studio.system.extensions", "{java.home}/FreeHEPPlugins");
                break;
            }
            case GROUP: {
                out = this.getAppProperties().getProperty("org.freehep.application.studio.group.extensions");
                break;
            }
            case USER: {
                out = this.getCommandLine().getOption("extdir");
                if (out != null) break;
                out = this.getAppProperties().getProperty("org.freehep.application.studio.user.extensions", "{user.home}/.FreeHEPPlugins");
                break;
            }
            default: {
                return null;
            }
        }
        if (out != null) {
            try {
                out = new File(out).getCanonicalPath();
            }
            catch (IOException x) {
                out = null;
            }
        }
        return out;
    }

    public ExtensionClassLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public List<PluginInfo> getPlugins() {
        return Collections.unmodifiableList(this.loadedPlugins);
    }

    public PluginInfo getPlugin(String name) {
        for (PluginInfo plugin : this.loadedPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public PluginMap getPluginMap() {
        if (this.pluginMap == null) {
            this.pluginMap = new PluginMap(this);
        }
        return this.pluginMap;
    }

    public void reportPluginException() {
        if (this.atLeastOnePluginFailedToLoad != null) {
            this.error("At least one plugin failed to initialize, see Plugin Manager for details", this.atLeastOnePluginFailedToLoad);
            this.atLeastOnePluginFailedToLoad = null;
        }
    }

    public void stopPlugin(PluginInfo plugin) {
        if ((plugin = this.getPlugin(plugin.getName())) == null) {
            return;
        }
        Plugin plug = plugin.getPlugin();
        if (plug == null || !plug.canBeShutDown()) {
            throw new IllegalArgumentException("Plugin can not be stopped");
        }
        plug.stop();
        plugin.setPlugin(null);
    }

    public void startPlugin(PluginInfo plugin) throws Throwable {
        Plugin plug;
        if ((plugin = this.getPlugin(plugin.getName())) == null) {
            return;
        }
        this.getAppProperties().putAll(plugin.getProperties());
        this.initializePlugin(plugin, this.extensionLoader);
        if (this.isApplicationInitialized && (plug = plugin.getPlugin()) != null && plugin.getErrorStatus() == null) {
            try {
                plug.postInit();
                if (this.isApplicationVisible) {
                    plug.applicationVisible();
                }
            }
            catch (Throwable t) {
                plugin.setErrorStatus(t);
                throw t;
            }
        }
        this.revalidate();
    }

    private Plugin initializePlugin(PluginInfo plugin, ClassLoader loader) throws Throwable {
        try {
            Class<?> c = loader.loadClass(plugin.getMainClass());
            Plugin plug = (Plugin)c.newInstance();
            plug.setContext(this);
            plugin.setPlugin(plug);
            plugin.setErrorStatus(null);
            return plug;
        }
        catch (Throwable t) {
            plugin.setErrorStatus(t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PluginInfo> buildPluginList(InputStream in) throws IOException {
        Properties user = this.getUserProperties();
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        try {
            Document doc = this.builder.build(in);
            List rootChildren = doc.getRootElement().getChildren();
            for (Element node : rootChildren) {
                PluginInfo plugin = new PluginInfo(node);
                plugin.loadUserProperties(user);
                result.add(plugin);
                if (!this.debugExtensions) continue;
                System.out.println("\t\tPlugin: " + plugin.getName());
            }
        }
        catch (JDOMException x) {
            if (this.debugExtensions) {
                x.printStackTrace();
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    public boolean loadPlugins(Collection<PluginInfo> plugins) {
        return this.loadPlugins(plugins, this.getExtensionLoader());
    }

    public boolean loadPlugins(Collection<PluginInfo> plugins, ExtensionClassLoader loader) {
        Plugin plug;
        boolean out = false;
        ArrayList<PluginInfo> okLoaded = new ArrayList<PluginInfo>(plugins.size());
        for (PluginInfo plugin : plugins) {
            if (this.loadedPlugins.contains(plugin)) {
                out = true;
                continue;
            }
            if (plugin.getErrorStatus() == null) {
                this.loadedPlugins.add(plugin);
                try {
                    Map<String, LibInfo> libs = this.pluginMap.getActiveLibraries(plugin);
                    for (LibInfo lib : libs.values()) {
                        File file = lib.getFile();
                        if (file == null) continue;
                        loader.addURL(file.toURI().toURL());
                    }
                    this.getAppProperties().putAll(plugin.getProperties());
                    okLoaded.add(plugin);
                }
                catch (Throwable t) {
                    plugin.setErrorStatus(t);
                    this.atLeastOnePluginFailedToLoad = plugin.getName().equals(this.pluginManagerName) ? t : new Exception("See Plugin Manager for details");
                }
                continue;
            }
            this.atLeastOnePluginFailedToLoad = plugin.getName().equals(this.pluginManagerName) ? plugin.getErrorStatus() : new Exception("See Plugin Manager for details");
        }
        for (PluginInfo plugin : okLoaded) {
            try {
                if (!plugin.hasMainClass()) continue;
                this.initializePlugin(plugin, loader);
            }
            catch (Throwable t) {
                plugin.setErrorStatus(t);
                this.atLeastOnePluginFailedToLoad = plugin.getName().equals(this.pluginManagerName) ? t : new Exception("See Plugin Manager for details");
            }
        }
        if (this.isApplicationInitialized) {
            for (PluginInfo plugin : okLoaded) {
                plug = plugin.getPlugin();
                if (plug == null || plugin.getErrorStatus() != null) continue;
                try {
                    plug.postInit();
                }
                catch (Throwable t) {
                    plugin.setErrorStatus(t);
                    this.atLeastOnePluginFailedToLoad = plugin.getName().equals(this.pluginManagerName) ? t : new Exception("See Plugin Manager for details");
                }
            }
        }
        if (this.isApplicationVisible) {
            for (PluginInfo plugin : okLoaded) {
                plug = plugin.getPlugin();
                if (plug == null || plugin.getErrorStatus() != null) continue;
                try {
                    plug.applicationVisible();
                }
                catch (Throwable t) {
                    plugin.setErrorStatus(t);
                    this.atLeastOnePluginFailedToLoad = plugin.getName().equals(this.pluginManagerName) ? t : new Exception("See Plugin Manager for details");
                }
            }
        }
        this.loadedPlugins.trimToSize();
        this.pluginMap.invalidate();
        this.revalidate();
        this.setStatusMessage("Plugins Loaded");
        return out;
    }

    @Override
    protected void fireInitializationComplete(ApplicationEvent event) {
        super.fireInitializationComplete(event);
        this.getEventSender().broadcast(event);
        for (PluginInfo info : this.loadedPlugins) {
            Plugin plugin = info.getPlugin();
            if (plugin == null || info.getErrorStatus() != null) continue;
            try {
                plugin.postInit();
            }
            catch (Throwable t) {
                info.setErrorStatus(t);
                this.atLeastOnePluginFailedToLoad = info.getName().equals(this.pluginManagerName) ? t : new Exception("See Plugin Manager for details", t);
            }
        }
        this.isApplicationInitialized = true;
    }

    @Override
    protected void fireApplicationVisible(ApplicationEvent event) {
        super.fireApplicationVisible(event);
        this.getEventSender().broadcast(event);
        for (PluginInfo info : this.loadedPlugins) {
            Plugin plugin = info.getPlugin();
            if (plugin == null || info.getErrorStatus() != null) continue;
            try {
                plugin.applicationVisible();
            }
            catch (Throwable t) {
                info.setErrorStatus(t);
                this.atLeastOnePluginFailedToLoad = info.getName().equals(this.pluginManagerName) ? t : new Exception("See Plugin Manager for details");
            }
        }
        this.isApplicationVisible = true;
        this.reportPluginException();
    }

    @Override
    protected void fireAboutToExit(ApplicationEvent event) {
        for (PluginInfo info : this.loadedPlugins) {
            Properties user = this.getUserProperties();
            info.saveUserProperties(user);
        }
        super.fireAboutToExit(event);
        this.getEventSender().broadcast(event);
    }

    protected FreeHEPLookup createLookup() {
        return FreeHEPLookup.instance();
    }

    protected PageManager createRealPageManager() {
        String name = this.getUserProperties().getProperty("pageManagerName", "Tabbed Panes");
        Lookup.Template template = new Lookup.Template(PageManager.class, name, null);
        Lookup.Result result = this.getLookup().lookup(template);
        if (!result.allInstances().isEmpty()) {
            return (PageManager)result.allInstances().iterator().next();
        }
        try {
            return super.createPageManager();
        }
        catch (Throwable t) {
            PageManager pm = (PageManager)this.getLookup().lookup(PageManager.class);
            if (pm != null) {
                return pm;
            }
            return new TabbedPageManager();
        }
    }

    @Override
    protected PageManager createPageManager() {
        return new DummyPageManager();
    }

    private static class DummyPageManager
    extends PageManager {
        private JPanel panel = new JPanel();

        private DummyPageManager() {
        }

        @Override
        protected Component getEmbodiment() {
            return this.panel;
        }

        @Override
        protected void iconChanged(PageContext page) {
        }

        @Override
        protected void show(PageContext page) {
        }

        @Override
        protected void titleChanged(PageContext page) {
        }
    }
}

