/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.console;

import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.freehep.jas.plugin.console.Console;
import org.lsst.ccs.plugin.jas3.console.FilteredMessage;

public class TracerWriter {
    private Console console;
    private PrintWriter defaultWriter;
    private Map<Color, PrintWriter> writers;

    TracerWriter(Console console) {
        this.console = console;
        this.defaultWriter = new PrintWriter((OutputStream)console.getOutputStream(null), true);
    }

    public void println(Object object) {
        this.defaultWriter.println(object);
    }

    public void println(FilteredMessage filteredMessage) {
        Color color;
        String text = filteredMessage.getMessage();
        if (text == null) {
            text = filteredMessage.getBusMessage().toString();
        }
        if ((color = filteredMessage.getColor()) == null) {
            this.defaultWriter.println(text);
        } else {
            PrintWriter writer;
            if (this.writers == null) {
                this.writers = new HashMap<Color, PrintWriter>(4);
            }
            if ((writer = this.writers.get(color)) == null) {
                SimpleAttributeSet style = new SimpleAttributeSet();
                style.addAttribute(StyleConstants.Foreground, color);
                writer = new PrintWriter((OutputStream)this.console.getOutputStream((AttributeSet)style), true);
                this.writers.putIfAbsent(color, writer);
            }
            writer.println(text);
        }
        EnumSet<FilteredMessage.Flag> flags = filteredMessage.getFlags();
        if (flags != null) {
            flags.forEach(flag -> {
                switch (flag) {
                    case ATTENTION: {
                        this.console.getToolkit().beep();
                    }
                }
            });
        }
    }

    public void reset() {
        this.writers = null;
        DefaultCaret caret = (DefaultCaret)this.console.getCaret();
        caret.setUpdatePolicy(0);
    }
}

