/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.IOException;
import java.io.InputStream;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.utilities.jars.CommonResources;

public class SubsystemBootFromStream {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            SubsystemBootFromStream.usage();
            return;
        }
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "true");
        System.setProperty("org.lsst.ccs.testcontext", testContext);
        String pathName = args[1];
        String subsystemAlias = args[0];
        if (pathName.endsWith(".xml")) {
            throw new IllegalArgumentException("Spring no longer supported");
        }
        String propertiesFileName = null;
        if (args.length > 2) {
            propertiesFileName = args[1];
        }
        Subsystem subsystem = BootUtils.getSubsystemFromFile(pathName, propertiesFileName, subsystemAlias);
        subsystem.start();
    }

    static InputStream getInput(String pathName) throws IOException {
        return CommonResources.getInput(SubsystemBootFromStream.class, (String)pathName);
    }

    static void usage() {
        System.err.println("usage: java org.lsst.ccs.startup.SubsystemBootfromStream pathName [optionalConfigPropertiesFile]\n where filename is  xx.ser or xx.groovy or xx.groo\n pathName could be file (with '/' file separator) or resource path");
    }
}

