/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.tutorial;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.swing.popup.HasPopupItems;

public class AdvancedTutorialPage
extends JPanel
implements ManagedPage,
HasPopupItems {
    private PageContext pageContext;
    private JCheckBox vetoCheckBox;
    private JTextField titleField;

    public AdvancedTutorialPage() {
        super(new BorderLayout());
        JEditorPane text = new JEditorPane("text/html", "I am an AdvancedTutorialPage. Close me using my popup menu, or by clicking the x in my page tab or the close button below.<p>I print messages to standard output when I am selected or deselected which should be trapped and appear in a console window below.<p>I have a custom popup menu with an extra item added.<p>You can veto close operations, and change my title using the controls at the bottom of the page.");
        this.add((Component)text, "Center");
        this.add((Component)this.createControls(), "South");
    }

    public boolean close() {
        if (this.vetoCheckBox.isSelected()) {
            JOptionPane.showMessageDialog(this, "I refuse to close!");
            return false;
        }
        return true;
    }

    public void setPageContext(PageContext pc) {
        this.pageContext = pc;
        this.titleField.setText(pc.getTitle());
        this.titleField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTitle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTitle();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTitle();
            }

            private void updateTitle() {
                AdvancedTutorialPage.this.pageContext.setTitle(AdvancedTutorialPage.this.titleField.getText());
            }
        });
    }

    public void pageSelected() {
        System.out.println("I've been selected");
    }

    public void pageDeselected() {
        System.out.println("I've been deselected");
    }

    public void pageIconized() {
        System.out.println("I've been iconized");
    }

    public void pageDeiconized() {
        System.out.println("I've been de-iconized");
    }

    public void pageClosed() {
        System.out.println("I've been closed");
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        JMenuItem extra = new JMenuItem("Extra");
        extra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(AdvancedTutorialPage.this, "Extra menu item selected!");
            }
        });
        menu.insert(extra, 0);
        return menu;
    }

    private JPanel createControls() {
        JPanel controls = new JPanel(new FlowLayout());
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedTutorialPage.this.pageContext.close();
            }
        });
        controls.add(closeButton);
        this.vetoCheckBox = new JCheckBox("Veto close");
        controls.add(this.vetoCheckBox);
        controls.add(new JLabel("Title:"));
        this.titleField = new JTextField(20);
        controls.add(this.titleField);
        return controls;
    }
}

