/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Color;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListener;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryContext;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryTreeMainPanel;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryBusMaster {
    private DictionaryTreeMainPanel mainPanel;
    private AgentMessagingLayer messagingAccess;

    public DictionaryBusMaster(AgentMessagingLayer messaginAccess) {
        this.messagingAccess = messaginAccess;
        this.mainPanel = new DictionaryTreeMainPanel(new CommandListener(){

            @Override
            public String sendCommand(String cmdName, Object[] cmdArgs, String destination) {
                return DictionaryBusMaster.this.executeSyncInvoke(cmdName, cmdArgs, destination);
            }

            @Override
            public Object[][] getConnectedAgents() {
                return DictionaryBusMaster.this.busMasterGetConnectedAgents();
            }

            @Override
            public TreeBranch<DictionaryContext> buildDictionaryTree(String destination) {
                return DictionaryBusMaster.this.busMasterBuildDictionaryTree(destination);
            }

            @Override
            public boolean isInEngineeringMode(String destination) {
                Object res = DictionaryBusMaster.this.executeInternalSyncInvoke("isInEngineeringMode", new Object[0], destination);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
                return false;
            }
        });
    }

    public DictionaryTreeMainPanel getMainPane() {
        return this.mainPanel;
    }

    public void initGUI() {
        this.messagingAccess.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.mainPanel);
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }

    public Object[][] busMasterGetConnectedAgents() {
        List agentList = this.messagingAccess.getAgentPresenceManager().listAgents(0);
        int i = 0;
        Object[][] res = new Object[agentList.size()][1];
        for (AgentInfo a : agentList) {
            res[i][0] = a;
            ++i;
        }
        return res;
    }

    TreeBranch<DictionaryContext> busMasterBuildDictionaryTree(String destination) {
        Object systemDictionary = this.executeInternalSyncInvoke("getSystemDictionary", new Object[0], destination);
        Map dictionaryMap = (Map)systemDictionary;
        TreeBranch dictionaryTree = null;
        if (dictionaryMap != null) {
            String aPath = dictionaryMap.keySet().toArray(new String[0])[0];
            String root = aPath.split("/")[0];
            Dictionary rootDictionary = (Dictionary)dictionaryMap.remove(root);
            TreeBranch treeWalker = dictionaryTree = new TreeBranch((Serializable)new DictionaryContext(root, rootDictionary));
            for (Map.Entry entry : dictionaryMap.entrySet()) {
                treeWalker = dictionaryTree;
                String[] pathTab = ((String)entry.getKey()).split("/");
                int i = 1;
                while (i < pathTab.length) {
                    boolean found = false;
                    if (treeWalker.getChildren() != null) {
                        Iterator it = treeWalker.getChildIterator();
                        while (it.hasNext() && !found) {
                            TreeBranch currIt = (TreeBranch)it.next();
                            if (!((DictionaryContext)currIt.getContent()).getName().equals(pathTab[i])) continue;
                            treeWalker = currIt;
                            found = true;
                            if (i != pathTab.length - 1) continue;
                            treeWalker.setContent((Serializable)new DictionaryContext(pathTab[i], (Dictionary)entry.getValue()));
                        }
                    }
                    if (!found) {
                        treeWalker = new TreeBranch(treeWalker, (Serializable)new DictionaryContext(pathTab[i], (Dictionary)entry.getValue()));
                    }
                    ++i;
                }
            }
        }
        return dictionaryTree;
    }

    public Object executeInternalSyncInvoke(String cmdName, Object[] p, String destination) {
        CommandRequest cmd = new CommandRequest(destination, cmdName, p);
        try {
            return new SynchronousCommandAgent(this.messagingAccess).invoke(cmd, 5000L);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String executeSyncInvoke(String cmdName, Object[] p, String destination) {
        CommandRequest cmd = new CommandRequest(destination, cmdName, p);
        try {
            Object res = new SynchronousCommandAgent(this.messagingAccess).invoke(cmd, 5000L);
            String strRes = null;
            strRes = res instanceof Exception ? StackTraceFormats.toString((Throwable)((Exception)res), (int)1) : (res == null ? "ok : VOID" : String.valueOf(res));
            return strRes;
        }
        catch (Exception e) {
            return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString((Throwable)e, (int)1) + "</font></html>";
        }
    }

    public void doShutdown() {
        this.messagingAccess.getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this.mainPanel);
    }
}

