package org.lsst.ccs.plugin.jas3.trending;

import hep.aida.IDataPointSet;
import java.util.ArrayList;
import java.util.EnumMap;
import static org.lsst.ccs.plugin.jas3.trending.AuxData.*;

/**
 * Encapsulates data required to produce a {@link Plot}.
 *
 * @author onoprien
 */
public class PlotData {

// -- Private parts : ----------------------------------------------------------
    
    private final IDataPointSet data;
    private EnumMap<Type,ArrayList<AuxData>> extras = new EnumMap<>(Type.class);

// -- Construction and initialization : ----------------------------------------
    
    public PlotData(IDataPointSet data) {
        this.data = data;
    }

// -- Getters : ----------------------------------------------------------------

    public IDataPointSet get() {
        return data;
    }
    
    public ArrayList<AuxData> get(Type what) {
        return extras.get(what);
    }
    
    public boolean isAvailable(Type what) {
        return get(what) != null;
    }
    
    public boolean isActive(Type what) {
        return false; // FIXME
    }
    
    
// -- Setters : ----------------------------------------------------------------
    
    public void add(AuxData data) {
        Type type = data.getType();
        if (type != null) {
            ArrayList<AuxData> dList = extras.get(type);
            if (dList == null) {
                dList = new ArrayList<>(2);
                extras.put(type, dList);
            }
            dList.add(data);
        }
    }
    
    public void set(EnumMap<Type,ArrayList<AuxData>> data) {
        extras = data;
    }
    
    public void set(Type what, ArrayList<AuxData> data) {
        extras.put(what, data);
    }

}
