package org.lsst.ccs.plugin.jas3.trending;

import hep.aida.ref.histogram.DataPointSet;

/**
 * Data point set that contains auxiliary data that can be displayed on a trending plot.
 *
 * @author onoprien
 */
public class AuxDataPointSet extends DataPointSet implements AuxData {

// -- Private parts : ----------------------------------------------------------
    
    private final Type type;
    private final String name;

// -- Construction and initialization : ----------------------------------------
    
    public AuxDataPointSet(Type type, String name) {
        super("", "", 2);
        this.type = type == null ? Type.parse(name) : type;
        this.name = name;
    }

// -- Getters : ----------------------------------------------------------------
    
    @Override
    public Type getType() {
        return type;
    }

    @Override
    public String getTypeName() {
        return name == null ? AuxData.super.getTypeName() : name;
    }

}
