package org.lsst.ccs.plugin.jas3.trending;

import java.util.HashMap;
import java.util.Map;

/**
 * Mix-in interface that identifies auxiliary data that may be displayed on trending plots.
 * Classes implementing this interface should also subclass one of the types that makes them
 * plottable by the AIDA plotter (typically <tt>IDataPointSet</tt>).
 * 
 * @author onoprien
 */
public interface AuxData {
    
    /**
     * Enumeration of types of auxiliary data.
     */
    public enum Type {
        
        ALARM("Alarm Level"), 
        WARNING("Warning Level");
        
        private final String label;
        
        Type(String label) {
            this.label = label;
        }
        
        static private final Map<String,Type> s2t;
        static {
            s2t = new HashMap<>();
            s2t.put("alarmLow", ALARM);
            s2t.put("alarmHigh", ALARM);
            s2t.put("warningLow", WARNING);
            s2t.put("warningHigh", WARNING);
        }
 
        static Type parse(String id) {
            return s2t.get(id);
        }
        
        String getLabel() {
            return label;
        }
    }
    
    /** Returns the type of this plottable data object. */
    Type getType();
    
    /** Returns string representation of the type of this plottable data object. */
    
    default String getTypeName() {
        Type t = getType();
        return t == null ? "" : t.name();
    }
    
}
