package org.lsst.ccs.plugin.jas3.jms;

import java.util.Properties;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;

/**
 * Encapsulates a user's JMS preferences
 *
 * @author turri
 */
class JmsPreferences {

    public static final String JMS_SERVER_PROPERTY = "org.lsst.jms.server";
    private static final String JMS_PORT_PROPERTY = "org.lsst.jms.port";
    private static final String JMS_USE_PROPERTY = "org.lsst.jms.use";
    private String server;
    private int port;
    private final Properties user;
    private boolean useTransport;

    JmsPreferences(Studio studio) {
        user = studio.getUserProperties();
        server = user.getProperty(JMS_SERVER_PROPERTY, "localhost");
        port = PropertyUtilities.getInteger(user, JMS_PORT_PROPERTY, 3700);
        useTransport = PropertyUtilities.getBoolean(user, JMS_USE_PROPERTY, false);
        if (useTransport && canUseTransport()) {
            activate();
        }
    }

    int getJmsPort() {
        return port;
    }

    String getJmsServer() {
        return server;
    }

    public boolean isUseTransport() {
        return useTransport;
    }

    void setJmsPort(int port) {
        this.port = port;
        PropertyUtilities.setInteger(user, JMS_PORT_PROPERTY, port);
    }

    public void setJmsServer(String server) {
        this.server = server;
        user.setProperty(JMS_SERVER_PROPERTY, server);
    }

    void setUseTransport(boolean selected) {
        this.useTransport = selected;
        PropertyUtilities.setBoolean(user, JMS_USE_PROPERTY, selected);
    }

    final boolean canUseTransport() {
        try {
            Class.forName("org.lsst.ccs.bus.jms.JMSMessagingFactory");
            return true;
        } catch (Throwable t) {
            return false;
        }
    }

    final void activate() {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", getJmsServer());
        System.setProperty("org.omg.CORBA.ORBInitialPort", String.valueOf(getJmsPort()));
        System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.jms.JMSMessagingFactory");
    }
}
