package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;

/**
 *
 * @author emarin
 */
public class ArgInputPanel extends JPanel implements ListSelectionListener{
    private JLabel[] argName;
        private HintTextField[] argInput;
        private JPanel formPane;
        private JEditorPane commandDesc;

        public ArgInputPanel() {
            this.setLayout(new BorderLayout());
            commandDesc = new JEditorPane();
            commandDesc.setBackground(new Color(0xed, 0xec, 0xeb)); //TODO : color must match system colors
            commandDesc.setEditable(false);
            commandDesc.setContentType("text/html");
            commandDesc.setText("      ");

            add(commandDesc, BorderLayout.CENTER);
            formPane = new JPanel();
            add(formPane, BorderLayout.SOUTH);
        }

        public void clearForm() {
            formPane.removeAll();
            commandDesc.setText("       ");
        }

        public final void fillFormPane(DictionaryCommand cmd) {
            clearForm();
            final int nbArgs = cmd.getArguments().length;
            formPane.setLayout(new GridLayout(nbArgs, 2));
            argName = new JLabel[nbArgs];
            argInput = new HintTextField[nbArgs];
            // createButton();
            for (int i = 0; i < nbArgs; i++) {
                argName[i] = new JLabel(cmd.getArguments()[i].getName());
                argInput[i] = new HintTextField(cmd.getArguments()[i].getSimpleType());

                formPane.add(argName[i]);
                formPane.add(argInput[i]);
            }

            String cmdDescString = cmd.getDescription() + "<br>";
            DictionaryArgument[] argTable = cmd.getArguments();
            String cmdArguments = "";
            for (int i = 0; i < argTable.length; i++) {
                cmdArguments = cmdArguments + " <b>" + argTable[i].getSimpleType() + "</b>"
                        + " " + argTable[i].getName()
                        + " : " + argTable[i].getDescription()
                        + "<br>";
            }

            commandDesc.setText("<html><h3>" + cmdDescString + "</h3><p>" + cmdArguments + "</p>");

            repaint();
            validate();
        }

        public JTextField[] getArgInput() {
            return argInput;
        }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        DictionaryCommand cmd = ((JList<DictionaryCommand>)lse.getSource()).getSelectedValue();
        clearForm();    
        if (cmd == null) {
            return;
        }
        fillFormPane(cmd);
    }
}
