package org.lsst.ccs.plugin.jas3.console;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.function.Predicate;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;

/**
 * New implementation of basic tracer. This version based vaguely on Bernard's StatusTestComponent.
 *
 * @author tonyj
 */
public class Tracer implements PageListener, StatusMessageListener, HasPopupItems {
    
    private final AgentMessagingLayer factory;
    private PrintWriter out;
    private Predicate<StatusMessage> filter = new RegularExpressionMessageFilter();

    Tracer(AgentMessagingLayer factory) {
        this.factory = factory;
    }

    @Override
    public void onStatusMessage(org.lsst.ccs.bus.messages.StatusMessage s) {
        if (filter == null || filter.test(s)) out.println(s);
    }

    @Override
    public void pageChanged(PageEvent pe) {
        if (pe.getID() == PageEvent.PAGECLOSED) {
            factory.removeStatusMessageListener(this);
        }
    }

    void start(PrintWriter out) {
        this.out = out;
        factory.addStatusMessageListener(this);
    }

    @Override
    public JPopupMenu modifyPopupMenu(JPopupMenu menu, final Component source, Point p) {
        JMenuItem item = new JMenuItem("Set Filter...");
        item.addActionListener(new ActionListener()
        {
            @Override
            public void actionPerformed(ActionEvent e) {
                RegularExpressionMessageFilter regexFilter = (RegularExpressionMessageFilter) filter;
                RegularExpressionMessageFilterPanel fp = new RegularExpressionMessageFilterPanel(regexFilter);
                int rc = JOptionPane.showConfirmDialog(Application.getApplication(), fp, "Select Filter", JOptionPane.OK_CANCEL_OPTION);
                if (rc == JOptionPane.OK_OPTION) {
                    fp.apply();
                }
            }
            
        });
        menu.insert(item,0);
        return menu;
    }
}
