package org.lsst.ccs.plugin.jas3.console;

import java.util.regex.Pattern;

/**
 * A graphical panel for controlling a RegularExpressionFilter.
 * @author tonyj
 */
class RegularExpressionMessageFilterPanel extends javax.swing.JPanel {
    private final RegularExpressionMessageFilter filter;

    /**
     * Creates new form RegularExpressionMessageFilterPanel
     */
    RegularExpressionMessageFilterPanel(RegularExpressionMessageFilter filter) {
        this.filter = filter;
        initComponents();
    }

    void apply() {
        filter.setVeto(vetoTextField.getText().isEmpty() ? null : Pattern.compile(vetoTextField.getText()));
        filter.setAccept(acceptTextField.getText().isEmpty() ? null : Pattern.compile(acceptTextField.getText()));
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
    javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
    vetoTextField = new javax.swing.JTextField();
    javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
    acceptTextField = new javax.swing.JTextField();

    jLabel1.setText("<html>Enter regular expressions that should be used for message filtering:");

    jLabel2.setText("Veto:");

    vetoTextField.setText(filter.getVeto() == null ? "" : filter.getVeto().toString());

    jLabel3.setText("Accept:");

    acceptTextField.setText(filter.getAccept() == null ? "" : filter.getAccept().toString());

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGap(0, 0, Short.MAX_VALUE))
          .addGroup(layout.createSequentialGroup()
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
              .addComponent(jLabel3)
              .addComponent(jLabel2))
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addComponent(vetoTextField)
              .addComponent(acceptTextField))))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel2)
          .addComponent(vetoTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel3)
          .addComponent(acceptTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );
  }// </editor-fold>//GEN-END:initComponents

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextField acceptTextField;
  private javax.swing.JTextField vetoTextField;
  // End of variables declaration//GEN-END:variables


}
