package org.lsst.ccs.plugin.jas3.console;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * Accepts or reject bus messages based on regular expressions applied to the
 * "toString" output of the message.
 *
 * @author tonyj
 */
public class RegularExpressionMessageFilter implements Predicate<StatusMessage> {

    private Pattern veto;
    private Pattern accept;

    @Override
    public boolean test(StatusMessage message) {
        String str = message.toString();
        if (veto != null) {
            if (veto.matcher(str).find()) {
                return false;
            }
        }
        if (accept != null) {
            return accept.matcher(str).find();
        }
        return true;
    }

    public Pattern getVeto() {
        return veto;
    }

    /**
     * If this pattern is found in the message it will be vetoed (not
     * displayed). The pattern is ignored if
     * <code>null</code>
     */
    public void setVeto(Pattern veto) {
        this.veto = veto;
    }

    public Pattern getAccept() {
        return accept;
    }

    /**
     * If the survives the veto, and this pattern pattern is found, it will be
     * displayed. The pattern is ignored if
     * <code>null</code>.
     */
    public void setAccept(Pattern accept) {
        this.accept = accept;
    }
}
