package org.lsst.ccs.plugin.jas3;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.application.studio.Plugin;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ApplicationManager;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;

/**
 *
 * @author onoprien
 */
public class LsstMasterPlugin extends Plugin {

// -- Private parts : ----------------------------------------------------------

    static private final Logger logger = Logger.getLogger(LsstMasterPlugin.class.getName());
    
    private final Agent agent;


// -- Life cycle : -------------------------------------------------------------
    
    public LsstMasterPlugin() {
        agent = new Agent("LSST-Graphical-Console", AgentInfo.AgentType.CONSOLE);
        agent.start();
    }

    @Override
    protected void init() {
    }

    @Override
    protected void postInit() {
    }

    @Override
    protected void shutdown() {
        try {
            agent.shutdown();
        } catch (Exception x) {
            logger.log(Level.WARNING, "Error while shutting down agent "+ agent.getName(), x);
        }
    }
    
    
// -- Implementing ApplicationManager: -----------------------------------------

    public AgentMessagingLayer getMessagingAccess() {
        return agent.getMessagingAccess();
    }
    
    
    
    
    
    
}
