/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.lsst.ccs.bus.messages.StatusCodec;
import org.lsst.ccs.utilities.logging.Logger;

public class KeyData
implements Serializable {
    public static Logger logger = Logger.getLogger("org.lsst.ccs.bus");
    private String key;
    private Object data;

    public KeyData(String key, Object data) {
        this.key = key;
        this.data = data;
    }

    public String getKey() {
        return this.key;
    }

    public List<KeyData> getContentAsRawList() {
        List<KeyData> listRes = null;
        if (this.data instanceof CodedData) {
            listRes = ((CodedData)this.data).listKV;
        }
        if (listRes == null) {
            return Collections.emptyList();
        }
        return listRes;
    }

    public List<KeyData> getContentAsList() {
        return StatusCodec.asSimpleKeyValueList(this.key, this.data);
    }

    public Optional<Object> getValue() {
        Object obj = null;
        try {
            obj = StatusCodec.decode(this.data);
        }
        catch (Exception e) {
            logger.warn((Object)("can't decode " + this.getKey()), e, new String[0]);
        }
        if (obj == null) {
            return Optional.empty();
        }
        return Optional.of(obj);
    }

    public Optional<byte[]> getCrystallizedData() {
        byte[] res = null;
        if (this.data instanceof CodedData) {
            CodedData obj = (CodedData)this.data;
            if (obj.content instanceof byte[]) {
                res = (byte[])obj.content;
            }
        }
        return Optional.ofNullable(res);
    }

    public String getUpdatedKey(String globalName) {
        if (this.key.length() == 0) {
            return globalName;
        }
        return String.valueOf(globalName) + '/' + this.key;
    }

    public Object getRawValue() {
        return this.data;
    }

    public String toString() {
        return "{key='" + this.key + '\'' + ", data=" + this.data + '}';
    }

    public static class CodedData
    implements Serializable {
        String className;
        Object content;
        List<KeyData> listKV;

        public CodedData(String className) {
            this.className = className;
        }

        public String toString() {
            return "CodedData{className='" + this.className + '\'' + ", content=" + this.content + ", listKV=" + this.listKV + '}';
        }
    }
}

