/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.utilities.dispatch.CommandFor;
import org.lsst.ccs.utilities.dispatch.ParallelCommandDispatcher;

class MockBusMessagingLayer
implements BusMessagingLayer {
    private final HashMap<String, AgentBehaviour> agentMap = new HashMap();
    private final BusRegistry busRegistry = new BusRegistry();
    private volatile boolean isClosed = false;
    private final Object lock = new Object();
    private boolean single;

    MockBusMessagingLayer(boolean single) {
        this.single = single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String agentName, Bus ... buses) throws IOException, DuplicateAgentNameException {
        if (this.isClosed) {
            this.isClosed = false;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                behaviour = new AgentBehaviour();
                this.agentMap.put(agentName, behaviour);
            }
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                int index = bus.ordinal();
                if (this.busRegistry.registry[index].contains(agentName)) {
                    throw new DuplicateAgentNameException(agentName, agentName);
                }
                this.busRegistry.registry[index].add(agentName);
                if (behaviour.dispatchers[index] == null) {
                    behaviour.dispatchers[index] = new ParallelCommandDispatcher(this.single);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRegisteredLocalAgents(Bus ... buses) {
        if (buses == null || buses.length == 0) {
            buses = Bus.values();
        }
        HashSet<String> result = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            for (String agent : this.agentMap.keySet()) {
                Bus[] busArray = buses;
                int n = buses.length;
                int n2 = 0;
                while (n2 < n) {
                    Bus bus = busArray[n2];
                    int index = bus.ordinal();
                    if (this.busRegistry.registry[index].contains(agent) && !result.contains(agent)) {
                        result.add(agent);
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFor(String agentName, Bus ... buses) {
        if (this.isClosed) {
            return;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.remove(agentName);
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                int index = bus.ordinal();
                this.busRegistry.registry[index].remove(agentName);
                if (behaviour != null) {
                    behaviour.dispatchers[index] = null;
                }
                ++n2;
            }
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends BusMessage> void sendMessage(String senderAgent, Bus<T> bus, final T message, String ... destinations) throws IOException {
        if (bus == null) {
            throw new IllegalArgumentException("null bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("null message");
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<String> busAgents = this.busRegistry.registry[bus.ordinal()];
            if (!busAgents.contains(senderAgent)) {
                throw new IllegalArgumentException("agent " + senderAgent + "not registered on " + bus);
            }
            int index = bus.ordinal();
            if (destinations.length == 0 || "".equals(destinations[0]) || "*".equals(destinations[0])) {
                destinations = this.busRegistry.registry[index].toArray(destinations);
            } else {
                destinations = this.busRegistry.registry[index].toArray(destinations);
                int length = destinations.length;
                destinations = Arrays.copyOf(destinations, length + 1);
                destinations[length] = "__";
            }
            CommandFor<MessagingAccessLayer.BusAccess> cmdMessage = new CommandFor<MessagingAccessLayer.BusAccess>(){

                public void invokeOn(MessagingAccessLayer.BusAccess instance) {
                    instance.processBusMessage(message);
                }
            };
            ArrayList<String> failed = new ArrayList<String>();
            String[] stringArray = destinations;
            int n = destinations.length;
            int n2 = 0;
            while (n2 < n) {
                String destination = stringArray[n2];
                AgentBehaviour behaviour = this.agentMap.get(destination);
                if (behaviour == null) {
                    if (!destination.equals("__")) {
                        failed.add(destination);
                    }
                } else {
                    ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                    if (dispatcher == null) {
                        if (!destination.equals("__")) {
                            failed.add(destination);
                        }
                    } else {
                        dispatcher.dispatchCommand((CommandFor)cmdMessage);
                    }
                }
                ++n2;
            }
            if (failed.size() != 0) {
                throw new DestinationsException(failed.toArray());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (forwarder == null) {
            throw new IllegalArgumentException("null forwarder");
        }
        if (this.isClosed) {
            return;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                throw new IllegalArgumentException("agent with no registration");
            }
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                int index = bus.ordinal();
                ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                if (dispatcher == null) {
                    throw new IllegalArgumentException(String.valueOf(agentName) + " not registered with " + bus);
                }
                dispatcher.addExecutant((Object)forwarder);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (forwarder == null) {
            throw new IllegalArgumentException("null forwarder");
        }
        if (this.isClosed) {
            return;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                return;
            }
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                int index = bus.ordinal();
                ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                if (dispatcher == null) {
                    return;
                }
                dispatcher.removeExecutant((Object)forwarder);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MessagingAccessLayer layer) throws DuplicateAgentNameException, IOException {
        String agentName;
        if (this.isClosed) {
            this.isClosed = false;
        }
        if ((agentName = layer.getName()) == null || "".equals(agentName)) {
            agentName = "__";
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                behaviour = new AgentBehaviour();
                this.agentMap.put(agentName, behaviour);
            }
            for (MessagingAccessLayer.BusAccess busAccess : layer.getBusAccesses()) {
                int index = busAccess.getBus().ordinal();
                if (this.busRegistry.registry[index].contains(agentName)) {
                    throw new DuplicateAgentNameException(agentName, agentName);
                }
                this.busRegistry.registry[index].add(agentName);
                if (behaviour.dispatchers[index] != null) continue;
                behaviour.dispatchers[index] = new ParallelCommandDispatcher(this.single);
                behaviour.dispatchers[index].addExecutant((Object)busAccess);
            }
        }
    }

    public void disconnect(MessagingAccessLayer accessLayer) {
        Bus[] buses = new Bus[accessLayer.getBusAccesses().size()];
        for (MessagingAccessLayer.BusAccess busAccess : accessLayer.getBusAccesses()) {
            buses[busAccess.getBus().ordinal()] = busAccess.getBus();
        }
        this.closeFor(accessLayer.getName(), buses);
    }

    private static class AgentBehaviour {
        ParallelCommandDispatcher[] dispatchers;

        AgentBehaviour() {
            Bus[] buses = Bus.values();
            this.dispatchers = new ParallelCommandDispatcher[buses.length];
        }
    }

    private static class BusRegistry {
        ArrayList<String>[] registry;

        BusRegistry() {
            Bus[] buses = Bus.values();
            this.registry = new ArrayList[buses.length];
            int ix = 0;
            while (ix < this.registry.length) {
                this.registry[ix] = new ArrayList();
                ++ix;
            }
        }
    }
}

