/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeWindow;

public class PresetList
extends AbstractTableModel {
    private final String KEY = "org.lsst.trending.custom";
    private final Studio app;
    private ArrayList<TimeWindow> data;

    public PresetList(Studio application) {
        this.app = application;
        this.restore();
    }

    public List<TimeWindow> getRecent(int maxSize) {
        List<TimeWindow> out = new ArrayList<TimeWindow>(this.data);
        Collections.sort(out, TimeWindow.compareByTime());
        if (maxSize < out.size()) {
            out = out.subList(0, maxSize);
        }
        Collections.sort(out, TimeWindow.compareByName());
        return out;
    }

    public TimeWindow get(int index) {
        return this.data.get(index);
    }

    public int indexOf(TimeWindow timeWindow) {
        return this.data.indexOf(timeWindow);
    }

    public void insert(TimeWindow timeWindow) {
        this.data.remove(timeWindow);
        String name = timeWindow.getName();
        int nElements = this.data.size();
        boolean needSave = timeWindow.isPersistent();
        int i = 0;
        while (i < nElements) {
            TimeWindow e = this.data.get(i);
            int out = name.compareTo(e.getName());
            if (out == 0) {
                needSave = needSave || e.isPersistent();
                this.data.set(i, timeWindow);
                break;
            }
            if (out < 0) {
                this.data.add(i, timeWindow);
                break;
            }
            ++i;
        }
        if (i == nElements) {
            this.data.add(timeWindow);
        }
        if (needSave) {
            this.save();
        }
        this.fireTableStructureChanged();
    }

    public void delete(TimeWindow timeWindow) {
        if (this.data.remove(timeWindow) && timeWindow.isPersistent()) {
            this.save();
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).getName();
            }
            case 1: {
                return this.data.get(rowIndex).getLowerEdgeString();
            }
            case 2: {
                return this.data.get(rowIndex).getUpperEdgeString();
            }
            case 3: {
                return this.data.get(rowIndex).isPersistent();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 3 ? Boolean.class : String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Start";
            }
            case 2: {
                return "End";
            }
            case 3: {
                return "Saved";
            }
        }
        throw new IllegalArgumentException();
    }

    private void save() {
        Properties prop = this.app.getUserProperties();
        if (prop != null) {
            int n = this.data.size();
            ArrayList<String> savedData = null;
            if (n != 0) {
                savedData = new ArrayList<String>(n);
                int i = 0;
                while (i < n) {
                    savedData.add(this.data.get(i).toCompressedString());
                    ++i;
                }
            }
            PropertyUtilities.setStringCollection((Properties)prop, (String)"org.lsst.trending.custom", savedData);
        }
    }

    private void restore() {
        Properties prop = this.app.getUserProperties();
        if (prop == null) {
            this.data = new ArrayList(0);
        } else {
            String[] savedData = PropertyUtilities.getStringArray((Properties)prop, (String)"org.lsst.trending.custom", (String[])new String[0]);
            this.data = new ArrayList(savedData.length);
            String[] stringArray = savedData;
            int n = savedData.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                try {
                    this.data.add(TimeWindow.parseCompressedString(s));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n2;
            }
            Collections.sort(this.data, TimeWindow.compareByName());
        }
    }
}

