/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.plugin.jas3.rest.RestPreferences;

class RestConnector
implements Runnable,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(RestConnector.class.getName());
    private final RestPreferences prefs;
    private final Client client;
    private DataChannel.DataChannelList channelList;
    private final Studio studio;
    private WebResource service;

    RestConnector(Studio studio, RestPreferences restPrefs) {
        this.studio = studio;
        this.prefs = restPrefs;
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create((ClientConfig)config);
        this.initialize();
    }

    private void initialize() {
        this.prefs.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public synchronized void run() {
        FreeHEPLookup lookup = this.studio.getLookup();
        if (this.service != null) {
            logger.log(Level.INFO, "Discarding old channel list");
            lookup.remove((Object)this.channelList);
            lookup.remove((Object)this.service, "dataserver");
            this.service = null;
        }
        String restFullUrl = this.prefs.getRestURL();
        logger.log(Level.INFO, "Connecting to rest server {0}", restFullUrl);
        WebResource service = this.client.resource(restFullUrl).path("dataserver");
        try {
            this.channelList = (DataChannel.DataChannelList)service.path("listchannels").accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
            lookup.add((Object)this.channelList);
            lookup.add((Object)service, "dataserver");
            this.service = service;
            logger.log(Level.INFO, "Connection successful, {0} channels read", this.channelList.list.size());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Connection unsuccessful", e);
        }
    }
}

