/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import jline.console.ConsoleReader;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extensions.jconsole.JConsole;
import org.freehep.jas.extensions.jconsole.JConsoleProvider;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.plugin.jas3.LsstPlugin;
import org.lsst.ccs.plugin.jas3.console.AlarmListener;
import org.lsst.ccs.plugin.jas3.console.Tracer;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;
import org.xml.sax.SAXException;

public class LsstConsolePlugin
extends LsstPlugin {
    private final String defaultConsoleName = "LSST Console";
    private final String defaultTracerName = "LSST Tracer";

    protected void init() throws SAXException, IOException {
        Studio studio = this.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add((Object)this);
        studio.getCommandTargetManager().add((CommandGroup)new ConsoleCommands());
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("LsstConsolePlugin.menus");
        builder.build(xml);
    }

    protected void postInit() {
        super.postInit();
        JConsoleService cs = (JConsoleService)this.getApplication().getLookup().lookup(JConsoleService.class);
        if (cs == null) {
            throw new IllegalStateException("JConsole service is not available");
        }
        cs.addConsoleProvider(JLineConsole.class, (JConsoleProvider)new JLineConsoleProvider());
        this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)new AlarmListener(this.getApplication()));
    }

    private JLineConsole createCommandConsole(String name) {
        Studio studio = this.getApplication();
        try {
            JConsoleService cs = (JConsoleService)this.getApplication().getLookup().lookup(JConsoleService.class);
            if (cs != null) {
                JLineConsole console = (JLineConsole)cs.createConsole(JLineConsole.class, name, null, null);
                final JLineShell shell = ConsoleCommandShell.createJLineShell((AgentMessagingLayer)this.getMessagingAccess(), (ConsoleReader)console.getConsoleReader());
                Thread t = new Thread("ConsoleInput-" + name){

                    @Override
                    public void run() {
                        try {
                            shell.run();
                        }
                        catch (IOException x) {
                            LsstConsolePlugin.this.getApplication().error("Error in command shell", (Throwable)x);
                        }
                    }
                };
                t.start();
                return console;
            }
        }
        catch (Exception x) {
            studio.error("Failed to start Console: " + name, (Throwable)x);
        }
        return null;
    }

    private JLineConsole createJTracerConsole(String name) {
        FreeHEPLookup lookup = this.getApplication().getLookup();
        JConsoleService cs = (JConsoleService)lookup.lookup(JConsoleService.class);
        if (cs != null) {
            Tracer tracer = new Tracer(this.getMessagingAccess());
            JLineConsole console = (JLineConsole)cs.createConsole(JLineConsole.class, name, null, (HasPopupItems)tracer);
            PrintWriter pw = new PrintWriter(console.getConsoleReader().getOutput(), true);
            cs.getPageContextForConsole((JConsole)console).addPageListener((PageListener)tracer);
            tracer.start(pw);
            return console;
        }
        return null;
    }

    private Console createTracerConsole(String name) {
        FreeHEPLookup lookup = this.getApplication().getLookup();
        ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
        if (cs != null) {
            Tracer tracer = new Tracer(this.getMessagingAccess());
            Console console = cs.createConsole(name, null, (HasPopupItems)tracer);
            ConsoleOutputStream out = console.getOutputStream(null);
            PrintWriter pw = new PrintWriter((OutputStream)out, true);
            cs.getPageContextForConsole(console).addPageListener((PageListener)tracer);
            tracer.start(pw);
            return console;
        }
        return null;
    }

    public class ConsoleCommands
    extends CommandProcessor {
        public void onLsstConsole() {
            LsstConsolePlugin.this.createCommandConsole("LSST Console");
        }

        public void onLsstTracer() {
            LsstConsolePlugin.this.createTracerConsole("LSST Tracer");
        }
    }
}

