/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingCommandResponse;
import org.lsst.ccs.scripting.ScriptingTimeoutException;

public class ScriptingSubsystemWrapper {
    private final SynchronousCommandAgent cmdAgent;
    private final AgentMessagingLayer messagingAccess;
    private final String subsystemName;

    protected ScriptingSubsystemWrapper(String subsystemName, AgentMessagingLayer messagingAccess) {
        this.messagingAccess = messagingAccess;
        this.cmdAgent = new SynchronousCommandAgent(messagingAccess);
        this.subsystemName = subsystemName;
    }

    public ScriptingCommandResponse synchCommand(int timeout, String commandName, Object ... args) throws ScriptingTimeoutException, Exception {
        CommandRequest cmd = new CommandRequest(this.subsystemName, commandName, args);
        return this.internalSynchCommand(timeout, cmd);
    }

    private ScriptingCommandResponse internalSynchCommand(int timeout, CommandRequest cmd) throws ScriptingTimeoutException, Exception {
        try {
            Object result = this.cmdAgent.invoke(cmd, timeout * 1000);
            return new ScriptingCommandResponse(result);
        }
        catch (TimeoutException ex) {
            ScriptingTimeoutException timeoutException = new ScriptingTimeoutException("timeout", ex);
            if (CCS.getThrowExceptions()) {
                throw timeoutException;
            }
            return new ScriptingCommandResponse(timeoutException);
        }
        catch (Exception e) {
            if (CCS.getThrowExceptions()) {
                throw e;
            }
            return new ScriptingCommandResponse(e);
        }
    }

    public ScriptingCommandResponse synchCommandLine(int timeout, String command) throws ScriptingTimeoutException, Exception {
        CommandRequest cmd = new CommandRequest(this.subsystemName, command);
        return this.internalSynchCommand(timeout, cmd);
    }

    public Future<Object> asynchCommand(String commandName, Object ... args) throws Exception {
        CommandRequest cmd = new CommandRequest(this.subsystemName, commandName, args);
        return this.internalAsynchCommand(cmd);
    }

    public Future<Object> internalAsynchCommand(CommandRequest cmd) throws Exception {
        Future f = null;
        try {
            f = this.cmdAgent.invokeFuture(cmd);
        }
        catch (Exception e) {
            final Exception ex = e;
            if (CCS.getThrowExceptions()) {
                throw ex;
            }
            f = new Future(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                public Object get() throws InterruptedException, ExecutionException {
                    return ex;
                }

                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return ex;
                }
            };
        }
        return f;
    }

    public Future<Object> asynchCommandLine(String command) throws Exception {
        CommandRequest cmd = new CommandRequest(this.subsystemName, command);
        return this.internalAsynchCommand(cmd);
    }
}

